<?php
/**
 * ISBBKK.php - File for search templates. ALl request variables have to prepended with "_".
 * 			 EG, _unit_select, _sortorder. This is for identifying the request variables for saveed searches
 *
 * @author $Author: dtong $
 * @version $Id: todcm.php,v 1.4 2011/05/13 12:47:49 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once('config_base.php');

class search_config_data extends search_config_base{

	static function get() {
		osa_load_template_obj(CMS_UBD_TEMPLATE, false);
		$data = new stdClass();
		/* search[x][0] is the menu, search[x][1] is the array of searches on the page */
		$data->search = array();
		/*
		 * Calendar search
		 */
		$data->search[2][0] = array('_menu_title' => 'Calendar', '_menu_image' => 'mapping.jpg');
		$data->search[2][1] = array(
			array('_type' => 'page_title', '_text' => 'Calendar Mapping Search'),
			array('_type' => 'sub_title', '_text' => 'Show me units and descriptions from:'),
			array('_type' => 'search', '_uniqueid' => 'cal', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' => //Handles can have any kind of data here.
					array('_title' => 'Calendar Mapping Search Result' ),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'calendar', '_form' => 'calendar_form', '_wintitle' => 'Calendar Mapping',
						'_width' => 1000, '_height'=>800, '_divid'=>'map_caldendar', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_htmlbefore'=>FALSE, '_htmlafter'=>FALSE, '_type'=>'general'),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'date_range'),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'html_text', '_text'=>'Sort my mapping result by '),
							array('_type'=>'html_select', '_name'=>'_sortorder', '_default'=>'0', '_options'=>'size="1"',
								  '_data'=>array('0'=>'Course Name','2'=>'Unit Start Date')),
						),

					),
			),
		);
		/*
		 * Stage 1 search
		 */
		$data->search[3][0] = array('_menu_title' => 'Learning Targets', '_menu_image' => 'mapping.jpg');
		$data->search[3][1] = array(
			array('_type' => 'page_title', '_text' => 'Learning Targets Mapping Search'),
			array('_type' => 'sub_title', '_text' => 'Show me Learning Targets NOT included in units from:'),
			array('_type' => 'search', '_uniqueid' => 'orphanlt', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Orphan Learning Targets Mapping Search Result' ),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'orphanlt', '_form' => 'orphanlt_form', '_wintitle' => 'Orphan Learning Targets Mapping',
						'_width' => 1000, '_height'=>800, '_divid'=>'map_orphanlt', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_select_size'=>10),
							/*
							array('_type'=>'newline', '_px'=>10),
							array('_type'=>'html_text', '_text'=>'Sort my mapping result by '),
							array('_type'=>'html_select', '_name'=>'_sortorder', '_default'=>'coursename,strand,standard,benchmark,target', '_options'=>'size="1"',
								'_data'=>array('coursename,strand,standard,benchmark,target'=>'Course Name',
													'strand,standard,benchmark,target,coursename'=>'Strand')), */
						),
					),
			),
			//This is the search for LTs
			array('_type'=>'line'),
			array('_type' => 'sub_title', '_text' => 'Show me Learning Targets in units from:'),
			array('_type' => 'search', '_uniqueid' => 'lt', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Learning Targets Mapping Search Result' ),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'lt', '_form' => 'lt_form', '_wintitle' => 'Learning Targets Mapping',
						'_width' => 1000, '_height'=>800, '_divid'=>'map_lt', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_select_size'=>10),
							/*
							array('_type'=>'newline', '_px'=>10),
							array('_type'=>'html_text', '_text'=>'Sort my mapping result by '),
							array('_type'=>'html_select', '_name'=>'_sortorder', '_default'=>'coursename,strand,standard,benchmark,target', '_options'=>'size="1"',
								'_data'=>array('coursename,unit_title,unitid'=>'Course Name',
													'coursename'=>'Strand')), */
						),
					),
			),
		);

		//Stage 2
		$data->search[4][0] = array('_menu_title' => 'Assessment', '_menu_image' => 'mapping.jpg');
		$data->search[4][1] = array(
			array('_type' => 'page_title', '_text' => 'Assessment Mapping Search'),
			array('_type' => 'sub_title', '_text' => 'Show me a graph of Assessments from:'),
			array('_type' => 'search', '_uniqueid' => 'assess', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Stage 2 Assessments Mapping',
							'_result_title' => 'Stage 2 Assessments',
							'_restype' => unit_config_data::ASSESSMENT_TYPE,
							'_data' => self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'search'),
							'_data_category' => self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'input'),
							'_no_select_items' => 'The following Assessment(s) are not used in any units',
							'_chartwin_width'=>900, '_chartwin_height'=>800, '_result_divid'=>'chart_unitlist',
							'_result_desc_title'=>'Assessment Description',
							'_default_col'=>0, '_default_img'=>0, // default sort column and icon down

					),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'graph', '_form' => 'unitsel_form', '_wintitle' => 'Assessments Mapping',
						'_width' => 700, '_height'=>650, '_divid'=>'map_assessment', '_ischart'=>TRUE,
						'_chart_divid' => 'flashchart_assessment', '_chart_width'=>600, '_chart_height'=>350,
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_select_size'=>10),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'html_text', '_text'=>'<b>Containing assessments from this selected assessment category:</b> &nbsp; '),
							array('_type'=>'newline', '_px'=>5),
							array('_type'=>'html_select', '_name'=>'_unit_select', '_default'=>'1',
								'_options'=>'size="' . count(self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'input')) . '"',
								'_data' => self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'input')),
						),
					),
			),
			//This is the stage 2 second search
			array('_type'=>'line'),
			array('_type' => 'sub_title', '_text' => 'Show me Assessments from:'),
			array('_type' => 'search', '_uniqueid' => 'assess2', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Stage 2 Assessments Mapping',
							'_description_name' => 'Assessment Description',
							'_type' => unit_config_data::ASSESSMENT_TYPE,
							'_data' => self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'search'),
							'_data_category' => self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'input'),
					),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'selcat', '_form' => 'selcat_form', '_wintitle' => 'Assessments Mapping',
						'_width' => 900, '_height'=>800, '_divid'=>'map_assessment2', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_select_size'=>10),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'html_text', '_text'=>'<b>Containing assessments from this selected assessment category:</b> &nbsp; '),
							array('_type'=>'newline', '_px'=>5),
							array('_type'=>'html_select', '_name'=>'_unit_select', '_default'=>'1',
								'_options'=>'size="' . count(self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'input')) . '"',
								'_data' => self::get_select_data(2,unit_config_data::ASSESSMENT_TYPE,'input')),
						),
					),
			),
		);

		//Stage 3
		$data->search[5][0] = array('_menu_title' => 'Activities', '_menu_image' => 'mapping.jpg');
		$data->search[5][1] = array(
			array('_type' => 'page_title', '_text' => 'Activities Mapping Search'),
			array('_type' => 'sub_title', '_text' => 'Show me a graph of Learning Activities from:'),
			array('_type' => 'search', '_uniqueid' => 'learn_act', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Stage 3 Learning Activities Mapping',
							'_result_title' => 'Stage 3 Learning Activities',
							'_restype' => unit_config_data::LEARNING_TYPE,
							'_data' => self::get_select_data(3,unit_config_data::LEARNING_TYPE,'search'),
							'_data_category' => self::get_select_data(3,unit_config_data::LEARNING_TYPE,'input'),
							'_no_select_items' => 'The following Learning Activity(ies) are not used in any units',
							'_chartwin_width'=>900, '_chartwin_height'=>800, '_result_divid'=>'chart_unitlist3',
							'_result_desc_title'=>'Learning Activities Description',
							'_default_col'=>0, '_default_img'=>0, // default sort column and icon down
					),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'graph', '_form' => 'unitsel_form', '_wintitle' => 'Learning Activities Mapping',
						'_width' => 700, '_height'=>650, '_divid'=>'map_learn', '_ischart'=>TRUE, '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						'_chart_divid' => 'flashchart_learn', '_chart_width'=>600, '_chart_height'=>350,
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_select_size'=>10),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'html_text', '_text'=>'<b>Containing Activities from this selected Activity category:</b> &nbsp; '),
							array('_type'=>'newline', '_px'=>5),
							//array('_type'=>'html_text', '_text'=>'<input type="hidden"  name="_unit_select"  value="1" " />'),

							array('_type'=>'html_select', '_name'=>'_unit_select', '_default'=>'2',
								'_options'=>'size="' . count(self::get_select_data(3,unit_config_data::LEARNING_TYPE,'input')) . '"',
								'_data' => self::get_select_data(3,unit_config_data::LEARNING_TYPE,'input')),

						),
					),
			),
			//This is the stage 3 second search
			array('_type'=>'line'),
			array('_type' => 'sub_title', '_text' => 'Show me Learning Activities from:'),
			array('_type' => 'search', '_uniqueid' => 'learn_act2', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Stage 3 Learning Activities Mapping',
							'_description_name' => 'Learning Activity Description',
							'_type' => unit_config_data::LEARNING_TYPE,
							'_data' => self::get_select_data_inc_checkbox(3,unit_config_data::LEARNING_TYPE,'search'),
							'_data_category' => self::get_select_data_inc_checkbox(3,unit_config_data::LEARNING_TYPE,'input'),
					),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'selcat', '_form' => 'selcat_form', '_wintitle' => 'Assessments Mapping',
						'_width' => 900, '_height'=>800, '_divid'=>'map_learn2', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_select_size'=>10),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'html_text', '_text'=>'<b>Containing Activities from this selected Activitiy category:</b> &nbsp; '),
							array('_type'=>'newline', '_px'=>5),
							//array('_type'=>'html_text', '_text'=>'<input type="hidden"  name="_unit_select"  value="1" " />'),
							array('_type'=>'html_select', '_name'=>'_unit_select', '_default'=>'1',
								'_options'=>'size="' . count(self::get_select_data_inc_checkbox(3,unit_config_data::LEARNING_TYPE,'input')) . '"',
								'_data' => self::get_select_data_inc_checkbox(3,unit_config_data::LEARNING_TYPE,'input')),
						),
					),
			),
		);

		//Big Picture
		$data->search[6][0] = array('_menu_title' => 'Big Picture', '_menu_image' => 'mapping.jpg');
		$data->search[6][1] = array(
			array('_type' => 'page_title', '_text' => 'Big Picture Mapping Search'),
			array('_type' => 'sub_title', '_text' => 'Show me the Benchmarks and Learning Targets from:'),
			array('_type' => 'search', '_uniqueid' => 'big', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
				array('_title' => 'Mapping Search Result', '_sort' => FALSE),  // order by grade_table(field sort)
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
				array('_handle' => 'standbench', '_form' => 'standbench_form', '_wintitle' => 'Big Picture',
						'_width' => 1000, '_height'=>800, '_divid'=>'map_standbench', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
						 	array('_type'=>'standbench', '_select_size'=>10, '_form' => 'standbench_form' ,
						 		  '_div_standard' => 'map_standard' , '_div_benchmark' => 'map_benchmark',
						 		  '_url' => 'map/select/get/standard/',
						 		  '_span_id' => 'span_sb', '_span_text' => 'Standards are not defined for the selected subject area.',
						 		  '_span_default' => ' please select a department.'),
							//array('_type'=>'newline', '_px'=>15),
							//array('_type'=>'html_text','_text'=>'<span ID="span_sb"><b>Please select a subject area.</b></span>'),
							array('_type'=>'html_text',
								'_text'=>'<div id="map_standard" style="margin-top:15px"><b>' .
									'Please select a subject area to see the list of related Standards.</b></div>'),
						),
					),
			),

			//This is the search for Essential Question
			array('_type'=>'line'),
			array('_type' => 'sub_title', '_text' => 'Show me the Teacher Essential Questions from:'),
			array('_type' => 'search', '_uniqueid' => 'eq', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Essential Question Search Result' ,
					      '_type'=>unit_config_data::IT_STANDARDS_TYPE, '_skip_enduring_understandings' => TRUE),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'eq', '_form' => 'eq_form', '_wintitle' => 'Essential Question Mapping',
						'_width' => 1000, '_height'=>780, '_divid'=>'map_eq', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
						    array('_type'=>'eq', '_select_size'=>10, '_form' => 'eq_form' ,
						 		  '_div_department' => 'map_eq_department' , '_div_essential' => 'map_eq_essential',
						 		  '_url' => 'map/select/get/essential/' ,
						 		  '_span_id' => 'span_eq', '_span_text' => 'EQs are not defined for the selected subject area.',
						 		  '_span_default' => ' Please select a department.'),
						    array('_type'=>'newline', '_px'=>15),
						    array('_type'=>'html_text','_text'=>'<div id="map_eq_essential"><b>' .
						    	'Please select a subject area to see the list of related Essential Questions.</b></div>'),
						),
					),
			),

			//This is the search for Like
			array('_type' => 'line'),
			array('_type' => 'sub_title', '_text' => 'Show me all units from:'),
			array('_type' => 'search', '_uniqueid' => 'allunits', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'All Unit Search Result'),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'allunits', '_form' => 'allunits_form', '_wintitle' => 'All Unit Mapping',
						'_width' => 1200, '_height'=>800, '_divid'=>'map_allunits', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
						    array('_type'=>'allunits', '_select_size'=>10, '_form' => 'allunits_form' ,
						 		  '_span_id' => 'span_allunits', '_span_text' => 'No Data',
						 		  '_span_default' => ' Please select a department.'),
						    array('_type'=>'html_text', '_text'=>'<b>That include the word(s)</b> '),
						    array('_type'=>'html_text','_text'=>'<input TYPE="text" ID="_allunits" VALUE="" size="25" ' .
						    	'onKeyPress="return noEnterKey(event)"></input>'),
						    array('_type'=>'html_text', '_text'=>' <b>in the unit description, title or resource.</b>'),
						),
					),
			),

		);
		//Modified Unit
		$data->search[7][0] = array('_menu_title' => 'Mapping Progress<br />(Admin only)', '_menu_image' => 'mapping.jpg', '_handle' => 'is_admin');
		$data->search[7][1] = array(
			array('_type' => 'page_title', '_text' => 'Mapping Progress Search'),
			array('_type' => 'sub_title', '_text' => 'Show me recently modified units from:'),
			array('_type' => 'search', '_uniqueid' => 'Publish', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' => //Handles can have any kind of data here.
				//array('_title' => ' Search Result' ),
				array(),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'publishunit', '_form' => 'publishunit_form', '_wintitle' => 'Unit Mapping',
						'_width' => 1000, '_height'=>800, '_divid'=>'map_publishunit', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_htmlbefore'=>FALSE, '_htmlafter'=>FALSE, '_type'=>'general',
								'_deptsel_default_all' => TRUE, '_select_size'=>10), //_deptsel_default_all makes all depts selected
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'date_range'),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'html_text', '_text'=>'Filter my mapping result by '),
							array('_type'=>'html_select', '_name'=>'_sortorder', '_default'=>'coursename,modifydate', '_options'=>'size="1"',
								  '_data'=>array('0'=>'All Units','1'=>'Published Units','2'=>'Editing Units')),
						),
					),
			),
/*
			//This is the search by unit type(normal,meta,integrated and unified)
			array('_type'=>'line'),
			array('_type' => 'sub_title', '_text' => 'Show me units:'),
			array('_type' => 'search', '_uniqueid' => 'unittype', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' =>
					array('_title' => 'Unit Type Mapping Search Result', '_type'=>unit_config_data::IT_STANDARDS_TYPE),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'unittype', '_form' => 'unittype_form', '_wintitle' => 'Unit Type Mapping',
						'_width' => 900, '_height'=>700, '_divid'=>'map_unittype', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_select_size'=>10,
							'_deptsel_default_all' => TRUE), //_deptsel_default_all makes all depts selected
							array('_type'=>'newline', '_px'=>10),
							array('_type'=>'html_text', '_text'=>'<b>With one or more of the following unit types:</b>'),
							array('_type'=>'newline', '_px'=>10),
							array('_type'=>'html_checkbox', '_name'=>'_normal', '_value'=>'1', '_checked'=>FALSE),
							array('_type'=>'html_text', '_text'=>' Normal&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'),
							array('_type'=>'html_checkbox', '_name'=>'_meta', '_value'=>'2', '_checked'=>FALSE),
							array('_type'=>'html_text', '_text'=>' Meta&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'),
							array('_type'=>'html_checkbox', '_name'=>'_integrated', '_value'=>'3,4', '_checked'=>FALSE),
							array('_type'=>'html_text', '_text'=>' Integrated&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'),
							array('_type'=>'html_checkbox', '_name'=>'_unified', '_value'=>'5,6', '_checked'=>FALSE),
							array('_type'=>'html_text', '_text'=>' Unified'),
						),
					),
			),
*/
			// Learning Target History
			array('_type'=>'line'),
			array('_type' => 'sub_title', '_text' => 'Show me learning target history from:'),
			array('_type' => 'search', '_uniqueid' => 'lthistory', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' => //Handles can have any kind of data here.
					array('_title' => 'Learning Target Mapping Search Result' ),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'lthistory', '_form' => 'lthistory_form', '_wintitle' => 'Learning Target Mapping',
						'_width' => 1000, '_height'=>800, '_divid'=>'map_lthistory', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_htmlbefore'=>FALSE, '_htmlafter'=>FALSE, '_type'=>'general', '_select_size'=>10,'_deptsel_default_all' => TRUE),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'date_range_current'),
							array('_type'=>'newline', '_px'=>15),
							array('_type'=>'html_text', '_text'=>'Show '),
							//array('_type'=>'html_select', '_name'=>'_sortorder', '_default'=>'hist_date', '_options'=>" size='1' onChange='showhidediv(this,\"map_lthistory\")' ",
							array('_type'=>'html_select', '_name'=>'_sortorder', '_default'=>'hist_date',
									'_options'=>" size='1' onChange=\"ajax_select(this,'map/select/get/lthistory/','map_lthistory'); return false;\"",
								  '_data'=>array('1'=>'Latest changes only','2'=>'All changes')),
							array('_type'=>'html_text', '_text'=>' With '),
							array('_type'=>'html_select', '_name'=>'_hist_type', '_default'=>'hist_type', '_options'=>" size='1'",
								  '_data'=>array('0'=>'All Types','1'=>'Type Add','2'=>'Type Modify','3'=>'Type Delete')),
						),

					),
			),

			// Admin Notes
			array('_type'=>'line'),
			array('_type' => 'sub_title', '_text' => 'Show me Admin Notes from:'),
			array('_type' => 'search', '_uniqueid' => 'adminnotes', //_uniqueid is used to identify this data for retrieval purpose
				//This is the data for the search handle
				'_search_data' => //Handles can have any kind of data here.
					array('_title' => 'Admin Notes Search Result'),
				//This is the data for the search input/selection page
				'_data' => //_handle is the search handle/library name
					array('_handle' => 'staticresource', '_form' => 'staticres_form', '_wintitle' => 'Admin Notes Search',
						'_width' => 1000, '_height'=>800, '_divid'=>'map_staticres', '_default_col'=>0, '_default_img'=>0, // default sort column and icon down
						//This is the content for a search
						'_search' => array (
							array('_type'=>'general', '_htmlbefore'=>FALSE, '_htmlafter'=>FALSE, '_select_size'=>10,'_deptsel_default_all' => TRUE),
							array('_type'=>'newline', '_px'=>15),
						),
					),
			),

		);

		$data->num = count($data->search);
		return $data;
	}
}
?>