<?php
/**
 * config_base.php - Base class for mapping configs
 *
 * @author $Author: dtong $
 * @version $Id: config_base.php,v 1.5 2011/01/31 09:13:04 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class search_config_base {
/*
	 * $stage can be 2 or 3 for now. $type can be assessment or learning activity
	 * Get unit select data. $datatype='input' is for input data
	 * $datatype=ANYTHING_ELSE is for search/handle data
	 */
	static function get_select_data($stage,$type,$datatype='input',$use_checkboxes=FALSE,$config_param=FALSE) {
		$CI = & get_instance();
		$max_count = $CI->config->item('cms_max_selects');
		if ($config_param != FALSE) {
			$config = $config_param;
		}
		else {
			$config = unit_config_data::get();
		}
		$data = & $config->stage[$stage][$type];
		if ( !is_array($data) ) {
			$data = & $config->extra[$type];
		}
		$ret = array();
		if ( !is_array($data) )
			return $ret;
		$count = 1;
		while (TRUE) {
			if ( $use_checkboxes )
				$flag = (osa_value($data, "_select_flag$count", FALSE) !== FALSE);
			else
				$flag = ( osa_value($data, "_select_flag$count", FALSE) !== FALSE &&
				  			 osa_value($data,"_select_checkbox_type$count",FALSE) === FALSE );
			if ( $flag ) {
				if ( $datatype == 'input' ) {
					//$ret["select$count"] = osa_value($data, "_select_title$count", FALSE);
					$ret["$count"] = osa_value($data, "_select_title$count", FALSE);
				}
				else {
					//$ret["select$count"] = osa_value($data, "_select$count", FALSE);
					$ret["$count"] = osa_value($data, "_select$count", FALSE);
				}
			}
			if ( $count >= $max_count ) {
				break;
			}
			$count++;
		}
		return $ret;
	}

	//Include checkbox data too
	static function get_select_data_inc_checkbox($stage,$type,$datatype='input') {
		return self::get_select_data($stage,$type,$datatype,TRUE);
	}
}
?>