<?php
/**
 * baseclass_goal.php - Base class to store functions for all goal templates.
 *
 * @author $Author: Samarth
 * @version $Id: baseclass_goal.php
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/
require_once('baseclass_all.php');

class baseclass_goal extends baseclass_all {

	/************************* URL functions ************************/
	//Function to get the unit page stage url
	protected static function stage_url() {
		//return base_url() . "goal/goal/stage/$stage/edit/_UNITID_";//_STAGENUM_/edit/_UNITID_';
		return base_url() . "goal/goal/stage/_STAGENUM_/edit/_UNITID_";
	}

	/************************* Button functions ************************/

	//Just to override the default height
	protected static function button_add($type,
			$alttext=FALSE, $width=FALSE, $height=500, $button_image=FALSE, $wintitle=FALSE) {
		return parent::button_add($type, $alttext, $width, $height, $button_image, $wintitle);
	}

	//Same as button_delete but can assign an event handler
	//TODO: parent needs the same function, add it please.
	protected static function button_delete_handle($type, $handle_array, $resource_name='resource') {
		$button = self::button_delete($type, $resource_name);
		$button['_event_handle'] = $handle_array;
		return $button;
	}

	//Function to get the unit page resource delete button.
	//This overrides the parent one because we need different stage url.
	protected static function button_delete($type, $res_name=FALSE) {
		$btn = parent::button_delete($type, $res_name);
		if ( $res_name === FALSE ) {
			$res_name = lang('template_res_delete_default_res_name');
		}
		$confirm_msg = sprintf(lang('template_res_delete_confirm_msg'), $res_name);
		$btn['_jscript'] = "return delUnitItem('" . self::resource_delete($type) . "','" . self::stage_url() .
								 "','_STAGEDIV_','{$confirm_msg}')";
		return $btn;
	}

	//Same as parent but uses different stage_url()
	protected static function button_delete_linkunit($type) {
		$btn = parent::button_delete_linkunit($type);
		$btn['_jscript'] = "return delUnitItem('" . self::linkunit_delete($type) . "','" . self::stage_url() .
								 "','_STAGEDIV_','" . lang('template_linkunit_delete_confirm_msg') . "')";
		return $btn;
	}

	//*** Depricated function, do not use ***
	//Function to get the goal page entry_point completion date button
	protected static function button_entry_point_completion_date($type,$action='read|edit',$input_size=20) {
		$url = base_url() . "goal/goal/update_entry/_UNITID_/";
		$date =
			 array ('_type' => $type, '_image' => 'calen.gif', '_action' => $action,'_image_id'=> "datebutton",
				 '_link' => $url,
			 	 '_alt_title' => 'Select Date', '_jscript' => "update_datetime('".$url."','frmgoal_create'); return false;", '_jevent' => 'onChange',
			 	 '_html_type' => 'text', '_html_id' => 'fielddate', '_html_size' => $input_size , '_html_readonly' => TRUE);

		return $date;
	}
}
