<?php
/**
 * baseclass_all.php - The base class for all the base classes.
 *
 * 	Some special strings contained within URL links that the template engine replaces:
 * 	_UNITID_
 * 	_STAGENUM_
 * 	_RESID_
 * 	_STAGEDIV_
 *
 * @author $Author: dtong $
 * @version $Id: baseclass_all.php,v 1.6 2011/05/13 03:39:31 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

class baseclass_all {
	const DEFAULT_RES_WINDOW_WIDTH = 800;
	const DEFAULT_RES_WINDOW_HEIGHT = 700;
	const DEFAULT_RES_WINDOW_DIVID = 'resource';

	/************************* URL functions ************************/

	//Function to get the unit page resource add url
	protected static function resource_add($type) {
		return base_url() . "unit/resource/add/_UNITID_/" . $type;
	}
	//Function to get the unit page resource edit url
	protected static function resource_edit($type) {
		return base_url() . "unit/resource/edit/_UNITID_/" . $type . "/_RESID_";
	}
	//Function to get the unit page resource delete url
	protected static function resource_delete($type) {
		return base_url() . "unit/resource/delete/_UNITID_/_RESID_/$type" ;
	}
	//Function to get the unit page resource delete url
	protected static function itstd_resource_delete($type) {
		return base_url() . "unit/resource/deleteo/_RESID_/$type";
	}
	//Function to get the unit page resource one url
	protected static function resource_one($type) {
		return base_url() . "unit/resource/one/_UNITID_/" . $type;
	}
	//Function to get the unit page resource one read url
	protected static function resource_oneread($type) {
		return base_url() . "unit/resource/oneread/_UNITID_/" . $type;
	}
	//Function to get the unit page render stage url
	protected static function stage_url() {
		return base_url() . 'unit/unit/stage/_STAGENUM_/edit/_UNITID_';
	}
	//Function to get the unit page select add url
	protected static function select_add($type) {
		return base_url() . 'unit/select/add/_UNITID_/' . $type;
	}
	//Function to get the unit page select delete url
	protected static function select_delete() {
		return base_url() . "unit/select/delete/_UNITID_/_RESID_";
	}
	//Function to get the unit page lt add url
	protected static function lt_add($type) {
		return base_url() . 'unit/lt/add/_UNITID_/' . $type;
	}
	//Function to get the unit page lt delete url
	protected static function lt_delete() {
		return base_url() . "unit/lt/delete/_UNITID_/_RESID_";
	}
	//Function to get the unit page lt_target_sort url
	//This is DEPRECATED, DO NOT USE.
	protected static function lt_target_sort() {
		return base_url() . "course/target/sort/_UNITID_/_RESID_/_TYPE_/_MODE_" ;
	}
	//Function to get the unit page lt_unit_sort url
	protected static function lt_unit_sort($sort_type, $mode=FALSE) {
			return base_url() . "unit/lt/sort/_UNITID_/_RESID_/$sort_type/$mode";
	}
	//Function to get the unit page resource_unit_sort url
	protected static function resource_unit_sort($type, $mode=FALSE) {
			return base_url() . "unit/resource/sort/_UNITID_/_RESID_/$type/$mode";
	}
	//Function to get the unit page itstd_unit_sort url
	protected static function itstd_unit_sort($sort_type, $mode=FALSE) {
			return base_url() . "unit/itstd/sort/_UNITID_/_RESID_/$sort_type/$mode";
	}
	//Function to get the unit page os add url
	protected static function os_add($type) {
		return base_url() . 'unit/outcomes/add/_UNITID_/' . $type;
	}
	//Function to get the unit page os delete url
	protected static function os_delete() {
		return base_url() . "unit/outcomes/delete/_UNITID_/_RESID_";
	}
	//Function to get the unit page os sort url
	protected static function os_sort() {
		return base_url() . "course/outcomes/sort/_COURSE_/_RESID_/_TYPE_/_MODE_" ;
	}
	//Function to get the unit page os unit sort url
	protected static function os_unit_sort($sort_type, $mode=FALSE) {
			return base_url() . "unit/outcomes/sort/_UNITID_/_RESID_/$sort_type/$mode";
	}
	//Function to get the unit page itstd add url
	protected static function itstd_add($type=FALSE,$upload_type=FALSE,$deptid=FALSE) {
		if ($deptid==FALSE)
		    return base_url() . "unit/itstd/addo/$type/$upload_type/_UNITID_";
		else
            return base_url() . "unit/itstd/sample/$type/$upload_type/$deptid";
	}
	//Function to get the unit page itstd delete url
	protected static function itstd_delete() {
		return base_url() . 'unit/itstd/delete/_UNITID_/_RESID_';
	}
	//Function to get the unit page tail add url
	protected static function tail_add($type,$upload_type) {
		return base_url() . "unit/itstd/addo/$type/$upload_type/_UNITID_";
	}
	//Function to get the unit page tail delete url
	protected static function tail_delete() {
		return base_url() . 'unit/itstd/delete/_UNITID_/_RESID_';
	}
	//Function to get the unit page gc add url
	protected static function gc_add($type,$upload_type) {
		return base_url() . "unit/itstd/addo/$type/$upload_type/_UNITID_";
	}
	//Function to get the unit page gc delete url
	protected static function gc_delete() {
		return base_url() . 'unit/itstd/delete/_UNITID_/_RESID_';
	}
	//Function to get the pop up to select unit(s).
	//protected static function select_add($type,$stage=FALSE) {
	protected static function linkunit_add($type,$stage=FALSE) {
		return base_url() . "template/linkunit/select/_UNITID_/".$type;
	}
	//Function to delete a linkunit unit.
	protected static function linkunit_delete($type) {
		return base_url() . "template/linkunit/delete_linkunit/_UNITID_/_RESID_/".$type; ;
	}


	/************************* Button functions ************************/

	/***** (Begin) These 3 functions are the same. *****/
	//Function to get the unit page resource upload button
	//TODO: Modify existing templates to use new function
	protected static function button_resource_upload($type,
			$stage=FALSE, $width=FALSE, $height=FALSE, $button_image=FALSE) {
		//Stage is no longer needed
		return self::button_add($type, FALSE, $width, $height, $button_image);
	}

	//Function to get the unit page resource upload button. Version 2
	protected static function button_resource_upload2($type,
			$alttext=FALSE, $width=FALSE, $height=FALSE, $button_image=FALSE, $wintitle=FALSE) {
		return self::button_add($type, $alttext, $width, $height, $button_image, $wintitle);
	}

	//Function to get the unit page resource upload button. Version 2
	//Newer version doesn't need stage number, the template code can figure out from the type.
	//Was button_resource_upload2() but we will stick with the short function name for all new templates
	protected static function button_add($type,
			$alttext=FALSE, $width=FALSE, $height=FALSE, $button_image=FALSE, $wintitle=FALSE) {
		if ( $wintitle === FALSE ) {
			if ( $alttext === FALSE ) {
				$wintitle = lang('template_res_add_btn_wintitle');
			}
			else {
				$wintitle = $alttext;
			}
		}
		if ( $alttext === FALSE ) {
			$alttext = lang('template_res_add_btn_alttex');
		}
		if ( $button_image === FALSE ) {
			$button_image = 'add.gif';
		}
		if ( $width === FALSE ) {
			$width = self::DEFAULT_RES_WINDOW_WIDTH;
		}
		if ( $height === FALSE ) {
			$height = self::DEFAULT_RES_WINDOW_HEIGHT;
		}
		return array ('_type' => $type, '_image' => $button_image, '_action' => 'edit',
		    '_link' => self::resource_add($type), '_alt_title' => $alttext,
			 '_jscript' => "newIframeWindow('" . self::resource_add($type) .
			    "','{$wintitle}',$width,$height,'" . self::DEFAULT_RES_WINDOW_DIVID . "');return false;");
	}
	/***** (End) These 3 functions are the same. *****/

	//This is like button_add() but supports handle events
	protected static function button_add_handle($type,
			$handle_array, $alttext=FALSE, $width=FALSE, $height=500, $image=FALSE, $wintitle=FALSE) {
		$button = self::button_add($type,$alttext,$width,$height,$image,$wintitle);
		$button['_event_handle'] = $handle_array;
		return $button;
	}

	//This is like button_add() but it only allows one resource so the add button becomes edit if a resource already exists.
	protected static function button_add_one($type,
			$alttext=FALSE, $width=FALSE, $height=500, $button_image=FALSE, $wintitle=FALSE) {
		if ( $wintitle === FALSE ) {
			if ( $alttext === FALSE ) {
				$wintitle = lang('template_res_add_btn_wintitle');
			}
			else {
				$wintitle = $alttext;
			}
		}
		if ( $alttext === FALSE ) {
			$alttext = lang('template_res_add_btn_alttex');
		}
		if ( $button_image === FALSE ) {
			$button_image = 'add.gif';
		}
		if ( $width === FALSE ) {
			$width = self::DEFAULT_RES_WINDOW_WIDTH;
		}
		return array ('_type' => $type, '_image' => $button_image, '_action' => 'edit',
				     '_link' => self::resource_one($type), '_alt_title' => $alttext,
					  '_jscript' => "newIframeWindow('" . self::resource_one($type) .
									"','{$wintitle}',$width,$height,'resource');return false;");
	}

	//Function to get a resource add button with a handle event. This is like button_add_one()
	protected static function button_add_one_handle($type,
			$handle_array, $alttext=FALSE, $image=FALSE, $width=400, $height=200, $wintitle=FALSE) {
		$button = self::button_add_one($type,$alttext,$width,$height,$image,$wintitle);
		$button['_event_handle'] = $handle_array;
		return $button;
	}

	//Function to get the unit page resource edit button
	protected static function button_edit($type,
			$width=FALSE, $height=FALSE, $alttext=FALSE, $img=FALSE, $wintitle=FALSE) {
		if ( $wintitle === FALSE && $alttext === FALSE ) {
			$wintitle = lang('template_res_edit_wintitle');
		}
		if ( $alttext === FALSE ) {
			$alttext = lang('template_res_edit_btn_alttext');
		}
		if ( $wintitle === FALSE ) {
			$wintitle = $alttext;
		}
		if ( $img === FALSE ) {
			$img='edit.gif';
		}
		if ( $width === FALSE ) {
			$width = self::DEFAULT_RES_WINDOW_WIDTH;
		}
		if ( $height === FALSE ) {
			$height = self::DEFAULT_RES_WINDOW_HEIGHT;
		}
		return array ('_type' => $type, '_image' => $img, '_action' => 'edit',
	 	    '_link' => self::resource_edit($type), '_alt_title' => $alttext,
	 	    '_jscript' => "newIframeWindow('" . self::resource_edit($type) .
			    "','{$wintitle}',$width,$height,'" . self::DEFAULT_RES_WINDOW_DIVID . "');return false;");
	}

	//Same as button_edit() but can assign an event handler
	protected static function button_edit_handle($type,
			$handle_array, $width=FALSE, $height=500, $alttext=FALSE, $img=FALSE, $wintitle=FALSE) {
		$button = self::button_edit($type ,$width, $height, $alttext, $img, $wintitle);
		$button['_event_handle'] = $handle_array;
		return $button;
	}

	//Function to get the unit page resource delete button
	protected static function button_delete($type, $res_name=FALSE) {
		if ( $res_name === FALSE ) {
			$res_name = lang('template_res_delete_default_res_name');
		}
		$confirm_msg = sprintf(lang('template_res_delete_confirm_msg'), $res_name);
		return array ('_type' => $type, '_image' => 'x.gif', '_action' => 'edit',
			 		'_link' => self::resource_delete($type), '_alt_title' => lang('template_res_delete_btn_alttext'),
			 		'_jscript' => "return delUnitItem('" . self::resource_delete($type) . "','" . self::stage_url() .
						"','_STAGEDIV_','{$confirm_msg}')" );
	}

	protected static function button_delete_handle($type, $handle, $res_name=FALSE) {
		$button = self::button_delete($type, $res_name);
		$button['_event_handle'] = $handle;
		return $button;
	}

	//Function to get the resource page help button popup. This is for the inside the resource popup.
	protected static function button_resource_popup($filename, $width=700, $height=700) {
		$href = base_url() . 'menu/help/popup/' . $filename;
		$img = "<img src='" . osa_imagepath() . "help.gif' border='0' />";
		return "<a href='{$href}' onclick='return openBrowserWindow(\"{$href}\",{$width},{$height})'>{$img}</a>";
	}

	//Function to bring up a iframe help popup. This is for the template page.
	protected static function button_help($filename=FALSE, $width=700, $height=700) {
		$url = base_url() . 'menu/help/popup/' . $filename;
		//unit_buttons->render() chekcs for _type but does not really use it, so just assign the string 'null'.
		//This will fool unit_buttons. 'null' is not PHP NULL and it is a string.
		return array ('_type' => 'null','_divid' => 'help', '_image' => 'help.gif', '_action' => 'edit',
				    	  '_link' => $url, '_alt_title' => lang('template_help_btn_alttext'),
				    	  '_jscript' => "return openBrowserWindow('$url', $width, $height)");
	}

	//Function to get an invisible button for layout alignment purpose
	protected static function button_none() {
		return array('_type' => 'null', '_action' => 'edit', '_empty_button' => TRUE);
	}

	//Function to get the unit page linkunit select link
	protected static function button_select_linkunit($type, $stage=FALSE, $width=900, $height=600) {
		return array ('_type' => $type, '_image' => 'unit.gif', '_action' => 'edit',
				    		'_link' => self::select_add($type,$stage), '_alt_title' => 'Select Unit(s)',
					 		'_jscript' => "newDhtmlWindow('" . self::linkunit_add($type,$stage) .
								"','Select Unit(s)',$width,$height,'linkunit');return false;");
	}

	//Function to delete a unit from linkunit
	protected static function button_delete_linkunit($type) {
		return array ('_type' => $type, '_image' => 'x.gif', '_action' => 'edit',
			 		 		'_link' => self::linkunit_delete($type), '_alt_title' => lang('template_linkunit_delete_btn_alttext'),
			 		 		'_jscript' => "return delUnitItem('" . self::linkunit_delete($type) . "','" . self::stage_url() .
					 	 		"','_STAGEDIV_','" . lang('template_linkunit_delete_confirm_msg') . "')" );
	}

	//Generic function to create a button array data structure.
	//_BTNLINK_ is $link, so you don't have to put the same link twice.
	protected static function button($type, $link, $jscript, $image, $alttitle=FALSE, $action='edit') {
		$jscript = str_replace('_BTNLINK_', $link, $jscript);
		return array ('_type' => $type, '_image' => $image, '_action' => $action,
						  '_link' => $link, '_alt_title' => $alttitle, '_jscript' => "$jscript;return false");
	}

	/***** All the following functions are deprecated, DO NOT use them for new templates *****/

	//Function to get the unit page sort up button
	protected static function button_sort_up($type,$stage=FALSE) {
		$resource_button_up =
			array ('_type' => $type, '_image' => 'moveup.gif', '_action' => 'edit',
		 	       '_link' => self::resource_unit_sort($type, 0), '_title'=>FALSE, '_alt_title' => 'Up',
		 	   	   '_jscript' => "return sortUnitItem('" . self::resource_unit_sort($type, 0). "','" . self::stage_url() .
					   "','_STAGEDIV_')" );
		return $resource_button_up;
	}

	//Function to get the unit page sort down button
	protected static function button_sort_down($type,$stage=FALSE) {
		$resource_button_down =
		 	array ('_type' => $type, '_image' => 'movedown.gif', '_action' => 'edit',
		 		   '_link' => self::resource_unit_sort($type, 1), '_title'=>FALSE, '_alt_title' => 'Down',
		 		   '_jscript' => "return sortUnitItem('" . self::resource_unit_sort($type, 1) . "','" . self::stage_url() .
					   "','_STAGEDIV_')" );
		return $resource_button_down;
	}

	//Function to get the unit page sort none button
	protected static function button_sort_none($type) {
		return self::button_none();
	}

}
