<?php
/**
 * html_data_model - Modle file for html_data.
 *
 * @author $Author: dtong $
 * @version $Id: html_data_model.php,v 1.2 2011/02/11 09:09:24 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class html_data_model extends CI_Model {

	function __construct() {
		parent::__construct();
   }

	function get($extid, $type, $question_index) {
		if ( !is_numeric($extid) || !is_numeric($type) )
			return FALSE;
		$this->db->select('*');
	   $this->db->from('template_htmldata');
	   $this->db->where('extid', $extid);
		$this->db->where('type', $type);
		if (isset($question_index) && $question_index !== FALSE)
			$this->db->where('question_index', $question_index);
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}

 	function add($extid, $type, $radio_select, $question_index, $weight) {
 		$data = new stdClass();
 		$data->extid = $extid;
 		$data->type = $type;
 		$data->radio_select = $radio_select;
 		if ( empty($question_index) ) {
 			$data->question_index = NULL;
 		}
 		else {
 			$data->question_index = $question_index;
 		}

 		if ( empty($weight) ) {
 			$data->weight = NULL;
 		}
 		else {
 			$data->weight = $weight;
 		}

 		if ($this->get($extid, $type, $question_index) !== FALSE){
 			return $this->update($data);
 		}
 		else {
			return $this->db->insert('template_htmldata', $data);
 		}
	}

	function update($data) {
		$this->db->where('extid', $data->extid);
		$this->db->where('type', $data->type);
		if (isset($data->question_index) && $data->question_index !== FALSE)
			$this->db->where('question_index', $data->question_index);
		return $this->db->update('template_htmldata', $data);
	}

	function delete($data) {
		$this->db->where('extid', $data->extid);
		$this->db->where('type', $data->type);
		if (isset($data->question_index) && $data->question_index !== FALSE)
			$this->db->where('question_index', $data->question_index);
		$this->db->delete('template_htmldata', $data);
		return TRUE;
	}

 	function get_chart($data) {
		if ( !is_numeric($data->extid) || !is_numeric($data->type) )
			return FALSE;
		$this->db->select('*,count(extid) total');
	   $this->db->from('template_htmldata');
	   $this->db->where('extid', $data->extid);
		$this->db->where('type', $data->type);
		$this->db->where('question_index', $data->question_index);
		$this->db->group_by('extid,type,question_index,radio_select');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
}