<?php
/**
 * template_htmldata_model.php - Page template_htmldata model
 *
 * @author $Author: dtong $
 * @version $Id: template_htmldata_model.php,v 1.3 2011/02/11 09:09:26 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class template_htmldata_model extends CI_Model {
  	function __construct() {
		parent::__construct();
    }

 	function get_template_htmldata($data) {
		$table_template_htmldata = $this->db->dbprefix('template_htmldata');
			if ( !is_numeric($data->extid) && !is_numeric($data->type) )
			return FALSE;
		$this->db->select('*');
	   $this->db->from($table_template_htmldata);
	   $this->db->where('extid', $data->extid);
		$this->db->where('type', $data->type);
		if (isset($data->question_index) && $data->question_index !== FALSE)
			$this->db->where('question_index', $data->question_index);
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
 	function add_template_htmldata($data) {
 		if ($this->get_template_htmldata($data) !== FALSE){
 			$this->update_template_htmldata($data);
 		}
 		else{
 			$table_template_htmldata = $this->db->dbprefix('template_htmldata');
			$this->db->insert($table_template_htmldata, $data);
 		}
		return TRUE;
	}
	function update_template_htmldata($data) {
		$table_template_htmldata = $this->db->dbprefix('template_htmldata');

		$this->db->where('extid', $data->extid);
		$this->db->where('type', $data->type);
		if (isset($data->question_index) && $data->question_index !== FALSE)
			$this->db->where('question_index', $data->question_index);
		$this->db->update($table_template_htmldata, $data);
		return TRUE;
	}
	function del_template_htmldata($data) {
		$table_template_htmldata = $this->db->dbprefix('template_htmldata');

		$this->db->where('extid', $data->extid);
		$this->db->where('type', $data->type);
		if (isset($data->question_index) && $data->question_index !== FALSE)
			$this->db->where('question_index', $data->question_index);
		$this->db->delete($table_template_htmldata, $data);
		return TRUE;
	}
 	function get_chart_template_htmldata($data) {
		$table_template_htmldata = $this->db->dbprefix('template_htmldata');
			if ( !is_numeric($data->extid) && !is_numeric($data->type) )
			return FALSE;
		$this->db->select('*,count(extid) total');
	   $this->db->from($table_template_htmldata);
	   $this->db->where('extid', $data->extid);
		$this->db->where('type', $data->type);
		$this->db->where('question_index', $data->question_index);
		$this->db->group_by('extid,type,question_index,radio_select');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
}