<?php
/**
 * techlib_model.php - Model file for tech library searches
 *
 * @author $Author: dtong $
 * @version $Id: techlib_model.php,v 1.10 2011/02/11 09:09:24 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Techlib_model extends CI_Model {

	function __construct() {
		parent::__construct();
		$this->load->Model('unit/unit_model');
	}

	function get($course_query, $type, $tech, $lib) {
		//$current = $this->unit_model->STATUS_CURRENT;
		$unittarget_table = $this->db->dbprefix('unit_target');
		$unit_table = $this->db->dbprefix('unit');
		$targettext_table = $this->db->dbprefix('target_text');
		$benchmark_table = $this->db->dbprefix('benchmark');
		$standard_table = $this->db->dbprefix('standard');
		$strand_table = $this->db->dbprefix('strand');
		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		if ($tech !== FALSE && $lib !== FALSE)
			$where = "(ut.select1=1 or ut.select2=1)";
		elseif ($tech !== FALSE)
			$where = "ut.select1=1";
		else
			$where = "ut.select2=1";

		$sql = "select c.name coursename,u.id unitid,u.title unit_title," .
				 "ut.select1 tech,ut.select2 lib,ut.benchmarkid,b.data benchmark " .
				 "from $unit_table u " .
				 "join $unitcache_table uc on uc.id=u.id " .
				 "join $unittarget_table ut on ut.unitid=uc.compare_unifint_id and ut.target_type={$type} " .
				 "left join $benchmark_table b on b.id=ut.benchmarkid " .
				 "left join $standard_table sd on b.standardid=sd.id " .
				 "left join $strand_table s on sd.strandid=s.id " .
				 "join ($course_query) c on u.courseid=c.id " .
				 "where $where " .
				 "and s.enabled=" . CMS_DB_BOOLEAN_TRUE . " " .
				 "and sd.enabled=" . CMS_DB_BOOLEAN_TRUE . " " .
				 "and b.enabled=" . CMS_DB_BOOLEAN_TRUE . " " .
				 "order by c.name,u.courseid,u.id";

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}
}