<?php
/**
 * tail_gc_model.php - Model file for tail and gc searches
 *
 * @author $Author: dtong $
 * @version $Id: tail_gc_model.php,v 1.6 2011/02/11 09:09:24 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Tail_gc_model extends CI_Model {

	function __construct() {
		parent::__construct();
		$this->load->Model('unit/unit_model');
	}

	function get($course_query, $params) {
		$current = $this->unit_model->STATUS_CURRENT;
		$unittarget_table = $this->db->dbprefix('unit_target');
		$benchmark_table = $this->db->dbprefix('benchmark');
		$standard_table = $this->db->dbprefix('standard');
		$strand_table = $this->db->dbprefix('strand');
		$unit_table = $this->db->dbprefix('unit');
		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		$where = 'ut.target_type in (' . implode(',',$params) . ')';

		$sql = "select c.name coursename,uc.id unitid,u.title unit_title," .
				 "ut.select1 tech,ut.select2 lib,ut.benchmarkid,b.data benchmark,ut.target_type " .
				 "from $unit_table u " .
				 "join $unitcache_table uc on uc.id=u.id " .
				 "join $unittarget_table ut on uc.compare_unifint_id=ut.unitid " .
				 "join $benchmark_table b on ut.benchmarkid=b.id and $where " .
				 "join $standard_table sd on b.standardid=sd.id " .
				 "join $strand_table s on sd.strandid=s.id " .
				 "join ($course_query) c on uc.courseid=c.id " .
				 " where s.enabled=" . CMS_DB_BOOLEAN_TRUE .
				 " and sd.enabled=" . CMS_DB_BOOLEAN_TRUE .
				 " and b.enabled=" . CMS_DB_BOOLEAN_TRUE .
				 " order by c.name,uc.courseid,uc.id";

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}
}
?>