<?php
/**
 * publishunit_model.php - Model file for publishunit
 *
 * @author $Author: dtong $
 * @version $Id: publishunit_model.php,v 1.9 2011/02/11 09:09:24 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Publishunit_model extends CI_Model {

	function __construct() {
		parent::__construct();
		$this->load->model('unit/unit_model');
	}

	function run_query($sql) {
		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}

	//Get the max version for each group in the unit table
	//This is used to determine is there copmare or not for a unit
	function get_max_versions() {
		$unit_table = $this->db->dbprefix('unit');
		//$sql = "select groupid,max(version) max_version FROM $unit_table where version is not null group by groupid";
		//This query is non standard but it works. It shows the statistics of versions in a group (unit.groupid)
		$sql = 'select groupid,max(version) max_version,count(groupid) version_count from unit u
				  where (status=' . CMS_UNIT_STATUS_PUBLISH . ' or status=' . CMS_UNIT_STATUS_EDIT .
				  ' or status=' . CMS_UNIT_STATUS_ARCHIVE . ') group by groupid';
		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return array();
		$res_array = $res->result();
		$ret = array();
		foreach($res_array as $version) {
			$ret[$version->groupid] = $version;
		}
		return $ret;
	}
}