<?php
/**
 * map_graph_model.php - Model file mapping graph
 *
 * @author $Author: dtong $
 * @version $Id: map_graph_model.php,v 1.13 2011/02/11 13:04:42 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Map_graph_model extends CI_Model {

	function __construct() {
		parent::__construct();
		$this->load->model('unit/unit_model');
	}

	/*
	 * Get Data resource_select a graph on the input parameters.
	 *
	 * @param query $course_query
	 * 	The query string.
	 * @param array $params
	 * 	Inside $params:
	 * 	_restype - The resource type that is being processed.
	 * 	_select_type - The selection type from the upload popup.
	 * 	_template - The template names and it is an array, can be one or more of 'ubd', 'pyp', 'myp'
	 *
	 * @return object
	 * 	Returns a database result - array of objects.
	 */
	function graphbyresource_select_data($course_query, $params, $use_rschoice=FALSE,$use_count=TRUE,$use_groupby=TRUE) {
		$where = '';
		$and='';
		if( isset($params['_restype']) && $params['_restype'] != FALSE ){
			if (is_array($params['_restype'])){
				$res_type = implode(',', $params['_restype']);
				$where = 'r.type in(' . $res_type . ')';
			}
			else{
				$where = 'r.type=' . $params['_restype'];
			}
			$and = ' and ';
		}
		if ( $use_rschoice ) {
			$where .= " $and rs.choice = %s ";
			$and = ' and ';
		}
		$count = '';
		if ( $use_count ) {
			$count = ' ,count(rs.choice) total ' ;
		}
		$groupby = '';
		if ( $use_groupby ) {
			$groupby = ' group by rs.choice,rs.type ' ;
		}

		if ( isset($params['_template']) && $params['_template'] != FALSE ) {
			$where .= $and . $this->where_template($params['_template']);
			$and = ' and ';
		}

		$whrer_type = '';
		if ( isset($params['_select_type']) && is_numeric($params['_select_type']) )
			$where .= "$and rs.type =" . $params['_select_type'];

		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		$resource_table = $this->db->dbprefix('resource');
		$resource_select_table = $this->db->dbprefix('resource_select');
		$unit_table = $this->db->dbprefix('unit');

		$sql = "select c.name coursename,u.id unitid,u.title unit_title,u.startdate,u.enddate,u.template,r.text1 res_description,
					u.description,rs.choice selectvalue,rs.type $count
					from $unit_table u
					join $unitcache_table uc on uc.id=u.id
					join $resource_table r on uc.compare_unif_id=r.unitid
					join $resource_select_table rs on r.id=rs.resourceid
					join ($course_query) c on uc.courseid=c.id
					where $where
					$groupby
					order by coursename,unit_title";

		if ( $use_rschoice )
			return $sql;

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}

	/*
	 * Get Query resource_select on click on the input parameters.
	 *
	 * @param query $course_query
	 * 	The query string.
	 * @param array $params
	 * 	Inside $params:
	 * 	_restype - The resource type that is being processed.
	 * 	_select_type - The selection type from the upload popup.
	 * 	_template - The template names and it is an array, can be one or more of 'ubd', 'pyp', 'myp'
	 *
	 * @return string
	 * 	Returns a query string - string.
	 */
	function graphbyresource_select_click($course_query,$params) {
		return $this->graphbyresource_select_data($course_query,$params,TRUE,FALSE,FALSE);
	}

	/*
	 * Get Data unit_selection a graph on the input parameters.
	 *
	 * @param query $course_query
	 * 	The query string.
	 * @param array $params
	 * 	Inside $params:
	 * 	_select_type - The selection type from the upload popup.
	 * 	_template - The template names and it is an array, can be one or more of 'ubd', 'pyp', 'myp'
	 *
	 * @return object
	 * 	Returns a database result - array of objects.
	 */
	function graphbyunit_selection_data($course_query, $params, $use_rschoice=FALSE,$use_count=TRUE,$use_groupby=TRUE) {
		$where = '';
		if (isset($params['_select_type']) && is_numeric($params['_select_type']))
			$where = " sc.type =". $params['_select_type'];
		else
			$where = " sc.text like "."'{$params['_select_type']}%'";

		if ( $use_rschoice ){
			$where = ' sc.id=%s ';
		}
		$count = '';
		if ( $use_count ) {
			$count = ' , count(us.catid) total ' ;
		}
		$groupby = '';
		if ( $use_groupby ) {
			$groupby = ' group by us.catid ' ;
		}

		if (isset($params['_template']) && $params['_template'] != FALSE)
			$where .= ' and ' . $this->where_template($params['_template']);

		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		$status = $this->unit_model->STATUS_CURRENT;
		$unit_select_table = $this->db->dbprefix('unit_selection');
		$selection_category_table = $this->db->dbprefix('selection_category');
		$unit_table = $this->db->dbprefix('unit');

		$sql = "select c.name coursename,u.id unitid,u.title unit_title,u.startdate,u.enddate, u.template,
						u.description,u.description res_description,sc.text,us.catid selectvalue $count ,sc.text type
						from $unitcache_table uc
						join $unit_table u on uc.id=u.id
						join $unit_select_table us on uc.compare_unif_id=us.unitid
						join $selection_category_table sc on sc.id = us.catid
						join ($course_query) c on uc.courseid=c.id
						where $where
						$groupby
						order by coursename,unit_title";

		if ( $use_rschoice )
			return $sql;

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}

	/*
	 *  Get Query unit_selection on click on the input parameters.
	 *
	 * @param query $course_query
	 * 	The query string.
	 * @param array $params
	 * 	Inside $params:
	 * 	_template - The template names and it is an array, can be one or more of 'ubd', 'pyp', 'myp'
	 *
	 * @return string
	 * 	Returns a query string - string.
	 */
	function graphbyunit_selection_click($course_query,$params) {
		return $this->graphbyunit_selection_data($course_query,$params, TRUE,FALSE,FALSE);
	}

 	/*
	 * Get get_category on the input parameters.
	 *
	 * @param int|string $params['_select_type']
	 * 	The $params['_select_type'] number or string.
	 * @param string $split
	 * 	The split string.
	 *
	 * @return array
	 * 	Returns a array .
	 */
    function  get_category($params,$split=false, $valueindex=0) {
    	$table_selection_category = $this->db->dbprefix('selection_category');
    	$where = '';
		if (isset($params['_select_type']) && is_numeric($params['_select_type']))
			$where = " where type =". $params['_select_type'];
		else
			$where = " where text like "."'{$params['_select_type']}%'";

		$sql = " select id ,text " ;
		$sql .= " from ".$table_selection_category;
		$sql .= $where . " and enabled=".CMS_DB_BOOLEAN_TRUE;
		$sql .= " order by text";
		$rowobj = $this->db->query($sql);

		if ( $rowobj->num_rows() <= 0 )
			return FALSE;
		$result = array();
    	foreach ($rowobj->result() as $value){
			if ($split != false) {
				$data = explode($split, $value->text);
				if (is_array($data) && array_key_exists($valueindex, $data)) {
					$tmp = trim($data[$valueindex]);
					$result[$value->id] = $tmp;
				}
			}
			else
				$result[$value->id] = $value->text;
		}

		 return $result;
    }

    /*
	 * Get query where_template on the input parameters.
	 *
	 * @param array $template
	 * 	The template array.
	 *
	 * @return string
	 * 	Returns a string .
	 */
	private function where_template($template=FALSE) {
		$where = '';
		if ($template === FALSE)
			return $where;

		$sep ='';
		$_template = '';
		if ($template !== FALSE){
			foreach ($template as $value){
				if ($value != FALSE){
					$_template .= $sep."'".$value."'";
					$sep = ',';
				}
			}
			$where = " u.template in(".$_template.")";
		}
		return $where;
	}
}
?>