<?php
/**
 * eq_model.php - Model file for eq search
 *
 * @author $Author: dtong $
 * @version $Id: eq_model.php,v 1.13 2011/02/11 09:09:24 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Eq_model extends CI_Model {

	function __construct() {
		parent::__construct();
		$this->load->model('unit/unit_model');
	}

	function run_query($sql) {
		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}

	function run_query_array($key, $sql) {
		$rows = $this->run_query($sql);
		if (!$rows)
			return FALSE;

		$data = array();
		foreach ($rows as $row) {
			$data[$row->$key][] = $row;
		}
		return $data;
	}

	// get all or one the selection_category (eq)
    function  get_essentials($deptid,$id=FALSE, $type=CMS_ESSENTIAL_QUESTION_TYPE) {
	    $this->db->select('id, type, text data');
		 $this->db->from('selection_category sc');
	    $this->db->where('departmentid',$deptid);
	    $this->db->where('enabled',CMS_DB_BOOLEAN_TRUE);
	    if ($id)
	    	$this->db->where('id',$id);
	    elseif ( $type )
	    	$this->db->where('type',$type); //Not needed if using id
	    $this->db->order_by('departmentid');
	    $this->db->order_by('type');
	    $this->db->order_by('id');
		$resobj = $this->db->get();

		if ($id) { // select one
			if ( $resobj->num_rows() != 1 )
     	 		return FALSE;
 			$result = $resobj->result();
	    	return $result[0] ;
		}
		$rowobj = $resobj->result();
	    return $rowobj = $resobj->result_array();  //return all value from table course_sis(All file)
    }

	// get a department
    function  get_department($deptid ) {
	    $this->db->select('id, name');
		$this->db->from('department');
	    $this->db->where('id',$deptid);
		$resobj = $this->db->get();
		if ( $resobj->num_rows() != 1 )
     	 	return FALSE;
 		$result = $resobj->result();
	    return $result[0] ;
    }

	function get_query($course_query, $essential, $resource_type) {
		$and_where = ' where';

		$unit_table = $this->db->dbprefix('unit');
		$resource_table = $this->db->dbprefix('resource');

		$selection_category_table = $this->db->dbprefix('selection_category');
		$unit_selection_table = $this->db->dbprefix('unit_selection');
		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		$sc_where = " where sc.enabled=".CMS_DB_BOOLEAN_TRUE;
		if ($essential)
			$sc_where .= " and sc.id=$essential";

		$eq_type = CMS_ESSENTIAL_QUESTION_TYPE;
		$sc_type = "and sc.type=$eq_type ";
		$sc_part = "select us.unitid,sc.id as catid,sc.text as cattext,sc.type as cattype,sc.departmentid " .
				    	"from $unit_selection_table us " .
				    	"left join $selection_category_table sc on sc.id=us.catid and sc.type=us.type $sc_type" .
						"$sc_where " .
		            "order by us.unitid,sc.departmentid, sc.id ";

		$fields = "r.id rid,r.type res_type,r.text1 res_description,r.courseid," .
					 "u.title unit_title,u.description,c.name coursename, " .
					 "s.catid, s.cattext,u.id unitid ";

		$sql_part = "from $resource_table r " .
						"right join $unitcache_table uc on uc.compare_unifint_id=r.unitid " .
						"join $unit_table u on uc.id=u.id " .
						"join ($course_query) c on uc.courseid=c.id " .
				   	"join ($sc_part) s on uc.compare_unifint_id=s.unitid " ;

		$where    = "where r.type=$resource_type ";

		$sql      = "select $fields " .
					"$sql_part " .
					"$where " .
					"order by coursename,unit_title,unitid,res_description";
		return $sql;
	}

    function get_category($res_type=CMS_ESSENTIAL_QUESTION_TYPE) {
    	$selection_category_table = $this->db->dbprefix('selection_category');
		$unit_selection_table = $this->db->dbprefix('unit_selection');

		$sc_type = "";
		if ( $res_type )
			$sc_type     = "and sc.type=$res_type ";

		$sc_part = "select us.unitid,sc.id as catid,sc.text as cattext,sc.type as cattype,sc.departmentid " .
				   "from $unit_selection_table us " .
				   "left join $selection_category_table sc on sc.id=us.catid and sc.type=us.type $sc_type" .
		           "order by us.unitid,sc.departmentid, sc.id ";
		return $sc_part;
	}

	// set title name
    function  set_titlename($datas,$isLang=TRUE,$prelang='map',$isNewLine=TRUE) {
		$pagetitle = '';
		$newline   = '';
		$getdata   = array();

		//example : $key is '_standard' , '_benchmark' from data array
    	foreach ($datas as $key => $value) {
    		if (count($getdata)==0) {
    			$getdata[$key] = $value;
    		} else if ($value) {
    		    $table = str_replace("_","",$key);  //not perfect
    			$getdata[$key]  = $this->get_titlename($table, $value);
    			$title = $getdata[$key];
    			if ($isLang && $title)
    				$pagetitle     .= $newline . lang($prelang.$key) .": " . $title  ;
    			else
    				$pagetitle     .= $newline . $title;

				if ($isNewLine)
    				$newline 	    = '<br />';
    		}
    	}

    	if ($pagetitle=='')
    		$pagetitle = $getdata['_pagetitle'];

    	$getdata['_pagetitle'] = $pagetitle;

    	return $getdata;
    }

    function onClick($data) {
    	if (!isset($data))
    		return '';

    	$url         = '"'. base_url() . $data['_url']. '"' ;
		$target_div  = '"' . $data['_div'] . '"';
		$formname 	 = '"' . $data['_formname'] . '"' ;

		$onClick 	 = "onChange='ajax_select(this, $url, $target_div, $formname);'";

    	return $onClick;
    }
}
?>