<?php
/**
 * allunits_model.php - Model for text search on resources and unit title and description
 *
 * @author $Author: dtong $
 * @version $Id: allunits_model.php,v 1.10 2011/05/09 04:48:53 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Allunits_model extends CI_Model {

	function __construct() {
		parent::__construct();
		//$this->load->model('unit/unit_model');
	}

	function run_query($sql) {
		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}

	//$search_words should be aleady processed in the calling handle like ignore 2 or less character words
	function get($course_query, $search_words) {
		$department_table = $this->db->dbprefix('department');
		$resource_table = $this->db->dbprefix('resource');
		$unit_table = $this->db->dbprefix('unit');
		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		if ( !is_array($search_words) || count($search_words) < 1 )
			return FALSE;

		$where_part = '';
		$or = '';
		foreach ($search_words as $word) {
			$word = trim($word);
			//actual string length controlled by handle, just to make sure it is 1 or more
			if (strlen($word) < 1)
				continue;
			$word = mysql_escape_string($word);
			//Words with 2 or 1 character are ignored. If you have ask then learn more about text search and stopwords.
			//TODO: Should put a message on the page to let the user know about the word length
			if ( !empty($word) ) {
				$where_part .= "$or u.title like '%{$word}%' or u.description like '%{$word}%' " .
									"or r.text1 like '%{$word}%'";
				$or = ' or';
			}
		}
		if ( empty($where_part) )
			return FALSE;

		$this->load->library('cms/cms_template/cms_template');
		$comma = '';
		$visible_types = '';
		//Gets the types from the 3 templates only and also excludes hidden types like reflection and misunderstanding
		//It is OK to hard code ubd, myp and pyp here since this search is only for these 3 types
		//If we have more templates then please add a new mapping template parameter to indicate the templates
		//and keep the default as array('ubd','pyp','myp') here
		//TODO: file_parts are hard coded here
		foreach (array('ubd','pyp','myp') as $template) {
			if ( ($types = $this->cms_template->types($template)) ) {
				$visible_types .= "{$comma}{$types}";
				$comma = ',';
			}
		}

		$sql = "select u.id unitid,u.title unit_title,u.description,c.name coursename," .
				 	"d.name departmentname,r.text1 resource " .
				 "from $unitcache_table uc " .
				 "join $unit_table u on uc.id=u.id " .
				 "left join $department_table d on uc.departmentid=d.id " .
				 "join $resource_table r on r.unitid=uc.compare_unif_id and r.type in ($visible_types) " .
				 "join ($course_query) c on uc.courseid=c.id " .
				 "where r.ispublic=1 and ($where_part) order by d.name,c.name,u.title";

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}
}
?>