<?php
/**
 * goal_model.php - Model goal
 *
 * @author $Author: dtong $
 * @version $Id: goal_model.php,v 1.11 2011/05/13 03:39:31 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class goal_model extends CI_Model {
	function __construct() {
		parent::__construct();
        $this->load->model('unit/unit_model');
        //osa_load_lang('general');
        //osa_load_lang('unit');
   }
	function get_goalall($creatorid, $enabledflag=FALSE, $filter=FALSE, $selectentry=FALSE) {
		$sql  = "select g.id, g.title, g.createdate,g.enabled,u.displayname,u.firstname,u.middlename,u.lastname,e.id entryid,e.type";
		$sql .=" from goal g ";
		$sql .=" left join entry_point e on e.goalid=g.id ";
		$sql .=" left join user u on g.creatorid=u.id ";
		$sql .=" left join team_members t on t.goalid=g.id ";
		//$sql .=" left join user ue on t.userid=ue.id ";
		//$where = " where g.id <> '' and e.type <> 0 ";
	   $where = " where g.id <> '' and g.deleted = 0 "; //fix null object

		if ($creatorid != FALSE){
			 $where .= " and (g.creatorid= $creatorid";
			 $where .= " or t.userid= $creatorid) ";
	   }
	   if($enabledflag !== FALSE && $enabledflag != CMS_ADMIN_ALL)
	   	 $where .= " and g.enabled = $enabledflag";

		if ($filter != FALSE) {
	    	// $where .= " and (g.title like '%$filter%')";
	    	$filter = addslashes($filter); // \'
	    	$where .= " and (g.title like '%$filter%')";
		}
		if($selectentry != FALSE)
	   	 $where .= " and e.type = $selectentry";

	   $group_by = " group by g.id";
		$order_by = " order by g.title";
	    $res = $this->db->query($sql.$where.$group_by.$order_by);;
		if ( $res->num_rows() <= 0 )
			return FALSE;

	   return $res->result();
	}
	function get_mygoal($creatorid, $type) {
		$table_goal = $this->db->dbprefix('goal');
		$table_entry_point = $this->db->dbprefix('entry_point');
		$table_linkunit = $this->db->dbprefix('linkunit');
		$table_resource = $this->db->dbprefix('resource');
		$sql_goal = "Select g.id,g.title ,e.type,lu.extid goalunit,r.unitid";
		$sql_goal .= " From $table_goal g ";
		$sql_goal .= " LEFT JOIN $table_entry_point e ON e.goalid=g.id ";
		$sql_goal .= " LEFT JOIN $table_linkunit lu ON lu.extid=g.id ";
		$sql_goal .= " LEFT JOIN $table_resource r ON r.unitid=g.id and r.type in ($type) ";
		//$sql_goal .= " LEFT JOIN $table_resource r ON r.unitid=e.id and r.courseid=e.type and r.type in ($type) ";
		$sql_goal .= " Where g.creatorid =". $creatorid;
		$sql_goal .= " and g.deleted = 0";
		//$sql_goal .= " and e.type <> 0 "; //fix null object

		$groupby = " Group by id" ;
		$orderby = " Order by g.title" ;
		$resobj = $this->db->query($sql_goal.$groupby.$orderby );
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		return $resobj->result();
	}
	function get_creator($goalid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		$this->db->select('u.id,u.displayname,u.firstname,u.middlename,u.lastname');
	   $this->db->from('goal g');
	   $this->db->join('user u', 'g.creatorid=u.id');
	   $this->db->where('g.id',$goalid);
	   $this->db->order_by('u.displayname');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
	function get_team($goalid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		$this->db->select('u.id,u.displayname,u.firstname,u.middlename,u.lastname,tm.iseditor');
	   $this->db->from('team_members tm');
	   $this->db->join('user u', 'tm.userid=u.id');
	   $this->db->where('tm.goalid',$goalid);
	   $this->db->order_by('u.displayname');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
	function get_goal($goalid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		$this->db->select('g.*');
		$this->db->from('goal g');
		$this->db->where('g.id',$goalid);
		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];
	}
	function get_entry_bygoal($goalid) {
		$this->db->select('g.id goalid, g.title ,  e.type, e.id entryid');
	   $this->db->from('goal g');
		$this->db->join('entry_point e', 'e.goalid=g.id', 'left');
		//->db->where('e.type',$type);
		$this->db->where('g.id',$goalid);
		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];
	}

	function get_goalbyentryid($type,$goalid) {
		$this->db->select('g.*, e.type, e.id entryid');
	   $this->db->from('goal g');
		$this->db->join('entry_point e', 'e.goalid=g.id', 'left');
		$this->db->where('e.type',$type);
		$this->db->where('e.goalid',$goalid);
		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];

	}
	function get_goalbyuserid($userid) {
		$this->db->select('*');
	   $this->db->from('goal');
		$this->db->where('creatorid',$userid);
		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];

	}
	function add_goal($goal=FALSE,$entry=FALSE) {
		$id = FALSE;
		$this->db->trans_begin();
		if ($goal != FALSE) {
			$this->db->insert('goal', $goal);
			$id = osa_db_lastinsertid($this->db);
			if ( !$id ) {
				$this->db->trans_rollback();
				return FALSE;
			}
		}
		if ($entry != FALSE) {
			if (isset($entry->goalid) == FALSE)
				$entry->goalid = $id;
			$this->db->insert('entry_point', $entry);
			$id = osa_db_lastinsertid($this->db);
			if ( !$id ) {
				$this->db->trans_rollback();
				return FALSE;
			}
		}
		$this->db->trans_commit();
		return $id;
	}
	function edit_goal($goalid,$data) {
		$this->db->where('id',$goalid);
		$this->db->update('goal', $data);
		return TRUE;
	}
	function edit_entry_point($entryid,$data) {
		$this->db->where('id',$entryid);
		$this->db->update('entry_point', $data);
		return TRUE;

	}

	function get_goalbytpyeid($tpyeid) {
		$this->db->select('g.*, e.type, e.id entryid,e.completedate');
	    $this->db->from('goal g');
		$this->db->join('entry_point e', 'e.goalid=g.id', 'left');
		$this->db->where('e.id',$tpyeid);

		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];
	}
	// fucnion team member dialog
	function get_team_member($goalid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		$this->db->select('u.id,u.displayname,u.firstname,u.middlename,u.lastname,tm.iseditor');
	   $this->db->from('team_members tm');
	   $this->db->join('user u', 'tm.userid=u.id', 'left');
	   $this->db->where('tm.goalid',$goalid);
	   $this->db->order_by('u.displayname');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
	function delete_team_member($goalid, $userid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		if ( !is_numeric($userid) )
			return FALSE;

		$this->db->query("DELETE FROM team_members where goalid = $goalid and userid = $userid ");
		return TRUE;
	}
	function insert_team_member($sql_data) {
		$team_members = $this->db->dbprefix('team_members');
		$sql = "INSERT INTO $team_members (userid,goalid) VALUES ";
		$this->db->query($sql . $sql_data );
		return TRUE;
	}
	function update_team_member($goalid,$userid,$data) {
		$this->db->where('goalid',$goalid);
		$this->db->where_in('userid',$userid);
		$this->db->update('team_members', $data);
		return TRUE;
	}
	function update_editor_member($goalid,$userid,$data) {
		$this->db->where('goalid',$goalid);
		$this->db->where('userid',$userid);
		$this->db->update('team_members', $data);
		return TRUE;
	}

	function get_goal_creator($goalid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		$this->db->select('u.id,displayname');
		$this->db->from('user u');
		$this->db->join('team_members tm', 'tm.userid=u.id', 'left');
		$this->db->where('tm.goalid',$goalid);
		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];
	}

	function get_goal_user_type($goalid,$userid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		if ( !is_numeric($userid) )
			return FALSE;
		$this->db->select('iseditor');
		$this->db->from('team_members');
		$this->db->where('goalid',$goalid);
		$this->db->where('userid',$userid);
		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];
	}
	function insert_creator($data) {
		$this->db->insert('team_members', $data);
		return TRUE;
	}

	function get_entrypoint($entryid) {
		$this->db->select('*');
		$this->db->from('entry_point e');
		$this->db->where('e.id',$entryid);

		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];
	}
	// end unit dialog
	function del_upload($table,$resourceid) {
	   $this->db->where_in('resourceid',$resourceid);
		$this->db->delete($table);
		return TRUE;
	}
  	function del_resource($table,$resourceid) {
	   $this->db->where_in('id',$resourceid);
		$this->db->delete($table);
		return TRUE;
	}
	function del_team_members($table,$goalid) {
	   $this->db->where('goalid',$goalid);
		$this->db->delete($table);
		return TRUE;
	}
	function del_entry_goal($table,$goalid) {
	   $this->db->where('goalid',$goalid);
		$this->db->delete($table);
		return TRUE;
	}
	function del_goal($table,$goalid) {
	   $this->db->where('id',$goalid);
		$this->db->delete($table);
		return TRUE;
	}
	function get_entry_pointbygoalid($goalid,$type) {
		$table_goal = $this->db->dbprefix('goal');
		$table_entry_point = $this->db->dbprefix('entry_point');
		$table_resource = $this->db->dbprefix('resource');

		$sql = "Select g.*, r.type, e.id entryid,r.id resid ";
		$sql .= " From $table_goal g ";
		$sql .= " LEFT JOIN $table_entry_point e ON e.goalid=g.id ";
		$sql .= " LEFT JOIN $table_resource r ON r.unitid=g.id and r.type in ($type)";
		//$sql .= " LEFT JOIN $table_resource r ON r.unitid=e.id and r.courseid=e.type and r.type in ($type)";

		$where = " Where g.id = ".$goalid;
		$resobj = $this->db->query($sql . $where );
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		return $resobj->result();
	}

	function check_goal_creator($goalid, $userid) {
		if ( !is_numeric($goalid) || !is_numeric($userid) )
			return FALSE;

		$table_goal = $this->db->dbprefix('goal');;
		$sql_goal = 'select creatorid userid, id goalid, '.CMS_GOAL_USER_EDITOR.' iseditor ';
		$sql_goal .= "from  $table_goal ";
		if ($goalid != FALSE)
			 $sql_goal .= "where id = ".$goalid;
		if ($userid != FALSE)
			 $sql_goal .= " and creatorid = ".$userid;
		$res = $this->db->query($sql_goal);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$rows = $res->result();
		return $rows[0];
	}

	function check_goal_editor($goalid, $userid) {
		if ( !is_numeric($userid) )
			return FALSE;

		$table_goal = $this->db->dbprefix('goal');;
		$sql_goal = 'select creatorid userid, id goalid, '.CMS_GOAL_USER_EDITOR.' iseditor ';
		$sql_goal .= "from  $table_goal ";
		if ($userid != FALSE)
			 $sql_goal .= "where creatorid = ".$userid;

		$table_member = $this->db->dbprefix('team_members');
		$sql_member = 'select userid, goalid, iseditor ';
		$sql_member .= "from  $table_member ";
		$sql_member .= "where iseditor = ".CMS_GOAL_USER_EDITOR;
		if ($userid != FALSE)
			 $sql_member .= " and userid = ".$userid;

		$sql  = 'select * from (' . $sql_goal .' union ' . $sql_member . ') m ';
		if ($goalid != FALSE)
		$sql .= 'where m.goalid = ' . $goalid;

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$rows = $res->result();
		return $rows[0];
	}
	function get_goal_write($goalid,$userid) {
			if ( !is_numeric($goalid) || !is_numeric($userid) )
			return FALSE;

		$table_goal = $this->db->dbprefix('goal');;
		$sql_goal = 'select creatorid userid, id goalid, '.CMS_GOAL_USER_EDITOR.' iseditor ';
		$sql_goal .= "from  $table_goal ";
		if ($userid != FALSE)
			 $sql_goal .= "where creatorid = ".$userid;

		$table_member = $this->db->dbprefix('team_members');
		$sql_member = 'select userid, goalid, iseditor ';
		$sql_member .= "from  $table_member ";
		if ($userid != FALSE)
			 $sql_member .= " where userid = ".$userid;

		$sql  = 'select * from (' . $sql_goal .' union ' . $sql_member . ') m ';
		if ($goalid != FALSE)
		$sql .= 'where m.goalid = ' . $goalid;

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$rows = $res->result();
		return $rows[0];
	}
	function get_goal_editor($goalid,$userid) {
		if ( !is_numeric($goalid) )
			return FALSE;
		$this->db->select('tm.iseditor,u.id,u.displayname');
	   $this->db->from('team_members tm');
	   $this->db->join('user u', 'tm.userid=u.id', 'left');
	   $this->db->where('tm.goalid',$goalid);
	    $this->db->where('u.id',$userid);
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		$rows = $res->result();
		return $rows[0];
	}

	function get_goaltopdf($goalid,$type=FALSE) {
		$table_goal = $this->db->dbprefix('goal');
		$table_entry_point = $this->db->dbprefix('entry_point');
		$table_linkunit = $this->db->dbprefix('linkunit');
		$table_resource = $this->db->dbprefix('resource');
		$sql_goal = "Select e.id entry_id , e.type, g.id";
		$sql_goal .= " From $table_goal g ";
		$sql_goal .= " LEFT JOIN $table_entry_point e ON e.goalid=g.id ";
		$sql_goal .= " JOIN $table_linkunit lu ON lu.extid=g.id ";
		if ($goalid != FALSE)
			$sql_goal .= " Where lu.extid=".$goalid;

		$sql_resource = "Select e.id entry_id , e.type, g.id";
		$sql_resource .= " From $table_goal g ";
		$sql_resource .= " LEFT JOIN $table_entry_point e ON e.goalid=g.id ";
		$sql_resource .= " JOIN $table_resource r ON r.unitid=g.id and r.type in ($type) ";
		//$sql_resource .= " JOIN $table_resource r ON r.unitid=e.id and r.courseid=e.type and r.type in ($type) ";
		if ($goalid != FALSE)
			$sql_resource .= " Where r.unitid=".$goalid;

		$sql  = 'select * from (' . $sql_goal .' union ' . $sql_resource . ') m ';
		$sql .= ' where m.id = ' . $goalid;

		$groupby = " Group by entry_id" ;
		$orderby = " Order by type" ;
		$resobj = $this->db->query($sql.$groupby.$orderby );
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		return $resobj->result();
	}
	function get_entry($goalid, $entryid=FALSE){
		if ( !is_numeric($goalid) )
			return FALSE;
		$this->db->select('e.id entryid, e.type, e.completedate, e.goalid');
	   $this->db->from('entry_point e');
		$this->db->where('e.goalid',$goalid);
		if ($entryid != FALSE)
			 $this->db->where('e.id',$entryid);

		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			  return FALSE;
		if ( is_numeric($entryid)) {
			  $rows = $resobj->result();
			  return $rows[0];
		}
		else {
			  return $resobj->result();
		}
	}
	function get_user($notin_ids=FALSE) {
		$this->db->select('id, displayname');
		$this->db->from('user');
		//$enabled='1';
		$this->db->where('enabled',CMS_ADMIN_ENABLE);
		if ($notin_ids != FALSE && isset($notin_ids)!=FALSE && is_array($notin_ids))
			$this->db->where_not_in('id', $notin_ids);
		$this->db->where_not_in('username', array($this->config->item('cms_admin_username'),$this->config->item('cms_guest_username')));

		$this->db->order_by('displayname');
		$res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;

		$user = $res->result();
		$result = array();
		foreach($user as $value) {
			$result[$value->id] = $value->displayname;
		}
		return $result;
	}
	function get_goal_byentryid($entryid) {
		$this->db->select('g.*, e.type, e.id entryid, e.completedate');
	    $this->db->from('goal g');
		$this->db->join('entry_point e', 'e.goalid=g.id', 'left');
		$this->db->where('e.id',$entryid);

		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows[0];
	}
	function is_edit_goal($goalid) {
		$this->load->library('cms/cms_cache');
		$cache_key = $goalid;
		if ( ($cache_val = $this->cms_cache->db_get(__METHOD__, $cache_key) ) !== NULL )
			return $cache_val;

		$user = $this->login_model->getLogin();
		if ( !is_numeric($goalid) || !$user ) {
			$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
			return FALSE;
		}

		$this->load->model('auth/access_model');
		if ( $this->access_model->checkaccess_any('admin_goal_write', $user, FALSE, FALSE) || $this->is_goal_admin() ||
			  $this->is_goal_creator($goalid)) {
			$this->cms_cache->db_add(__METHOD__, $cache_key, TRUE);
			return TRUE;
		}

		//Goal members can edit too
		if ($this->config->item('cms_goal_member_edit_support')){
			if ($this->is_goal_editor($goalid)) {
				$this->cms_cache->db_add(__METHOD__, $cache_key, TRUE);
				return TRUE;
			}
		}
		$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
		return FALSE;
	}
	function is_goal_admin() {
		//$this->load->library('cms/cms_cache');
		if ( $this->access_model->checkaccess_any_noexit('admin_goal_write') ) {
			return TRUE;
		}
		if ( ($user = $this->login_model->getLogin()) == FALSE ) {
   		return FALSE;
    	}
		$cache_key = $user->id;
		if ( ($cache_val = $this->cms_cache->db_get(__METHOD__, $cache_key) ) !== NULL )
			return $cache_val;

		$table_user_role = $this->db->dbprefix('user_role');;

    	//TODO: Should make this into one query instead of 2
   	$this->db->where('userid', $user->id);
   	//$this->db->where_or('type', CMS_GOAL_ADMIN_USER_TYPE);
   	$admintype = CMS_GOAL_ADMIN_USER_TYPE;
   	$admingroup = CMS_USERROLE_GROUP_GOAL;
   	$where = "(type='$admintype' OR grouping='$admingroup')";
   	$this->db->where($where);
   	$res = $this->db->get($table_user_role);
   	if ( $res->num_rows() > 0 ) {
   		$this->cms_cache->db_add(__METHOD__, $cache_key, TRUE);
    		return TRUE;
   	}
   	/*
		$this->db->where('userid', $user->id);
   	$this->db->where('grouping', CMS_USERROLE_GROUP_GOAL);
   	$res = $this->db->get($table_user_role);
   	if ( $res->num_rows() > 0 ) {
   		$this->cms_cache->db_add(__METHOD__, $cache_key, TRUE);
    		return TRUE;
   	} */

   	$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
    	return FALSE;
   }

	function is_goal_creator($goalid) {
		$this->load->library('cms/cms_cache');
		$cache_key = $goalid;
		if ( ($cache_val = $this->cms_cache->db_get(__METHOD__, $cache_key) ) !== NULL )
			return $cache_val;

		if ( !is_numeric($goalid) ) {
			$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
			return FALSE;
		}
		$table_goal = $this->db->dbprefix('goal');
    	if ( ($user = $this->login_model->getLogin()) == FALSE ) {
    		$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
   		return FALSE;
    	}
   	$this->db->where('id', $goalid);
   	$this->db->where('creatorid', $user->id);
   	$res = $this->db->get($table_goal);
   	if ( $res->num_rows() <= 0 ) {
   		$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
    		return FALSE;
   	}
   	$this->cms_cache->db_add(__METHOD__, $cache_key, TRUE);
    	return TRUE;
	}

	private function is_goal_editor($goalid) {
		if ( !is_numeric($goalid) ) {
			return FALSE;
		}
		$table_team_members = $this->db->dbprefix('team_members');
    	if ( ($user = $this->login_model->getLogin()) == FALSE ) {
   		return FALSE;
    	}
		$this->load->library('cms/cms_cache');
		$cache_key = $goalid;
		if ( ($cache_val = $this->cms_cache->db_get(__METHOD__, $cache_key) ) !== NULL ) {
			return $cache_val;
		}

   	$this->db->select('*');
		$this->db->from($table_team_members);
   	$this->db->where('goalid', $goalid);
   	$this->db->where('userid', $user->id);
   	$resobj = $this->db->get();
   	if ( $resobj->num_rows() <= 0 ) {
   		$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
    		return FALSE;
   	}
    	$row = $resobj->result();
    	$team_members = $row[0];
    	if (isset($team_members) && $team_members != FALSE && $team_members->iseditor != FALSE) {
    		$this->cms_cache->db_add(__METHOD__, $cache_key, TRUE);
			return TRUE;
    	}
    	$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
    	return FALSE;
	}

	function is_goal_member($goalid) {
		$this->load->library('cms/cms_cache');
		$cache_key = $goalid;
		if ( ($cache_val = $this->cms_cache->db_get(__METHOD__, $cache_key) ) !== NULL )
			return $cache_val;

		if ( !is_numeric($goalid) ) {
			$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
			return FALSE;
		}
		$table_team_members = $this->db->dbprefix('team_members');
    	if ( ($user = $this->login_model->getLogin()) == FALSE ) {
    		$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
   		return FALSE;
    	}
   	$this->db->select('*');
		$this->db->from($table_team_members);
   	$this->db->where('goalid', $goalid);
   	$this->db->where('userid', $user->id);
   	$resobj = $this->db->get();
   	if ( $resobj->num_rows() <= 0 ) {
   		$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
    		return FALSE;
   	}
		$this->cms_cache->db_add(__METHOD__, $cache_key, TRUE);
		return TRUE;
	}
	//Update table column deleted in a goal
	function update_deleted($goalid,$data) {
		$table_goal = $this->db->dbprefix('goal');;
		$this->db->where('id',$goalid);
		$this->db->update($table_goal, $data);
		return TRUE;
	}

	//CHeck to see does a goal has a survey or not
	function has_survey($goalid) {
		$this->db->select('surveyid');
		$this->db->from('survey_goal');
		$this->db->where('goalid', $goalid);
		$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 ) {
			return FALSE;
		}
		return TRUE;
	}
}
?>