<?php
/**
 * auth_ldap - LDAP authentication class
 *
 * @author $Author: dtong $
 * @version $Id: auth_ldap.php,v 1.8 2011/04/18 11:39:30 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

require_once('auth_base.php');

class auth_ldap extends auth_base {

	//$searchdn and $return_attrs overrides the default configs
   function authenticate($username, $password, $dbpassword, $return_attrs=FALSE, $searchdn=FALSE) {
   	if ( !$this->_check_ldap_lib() ) {
   		return FALSE;
   	}

      $ldapserver = $this->CI->config->item('cms_ldap_server');
      if ( !$searchdn ) {
      	$searchdn = $this->CI->config->item('cms_ldap_serach_dn');
      }
      $userattr = $this->CI->config->item('cms_ldap_serach_userattr');
      //$isadserver = $this->config->item('cms_ldap_adserver');
      $ldapuserdn = $this->CI->config->item('cms_ldap_bind_userdn');
      $ldappassword = $this->CI->config->item('cms_ldap_bind_password');

      if ( !($ldapconn = @ldap_connect($ldapserver)) ) {
      	log_message('error', "Failed to connect to LDAP server $ldapserver");
      	return FALSE;
      }
      //Do this if MS Active Server
      //if ( $isadserver ) {
      @ldap_set_option($ldapconn, LDAP_OPT_PROTOCOL_VERSION, '3');
      @ldap_set_option($ldapconn, LDAP_OPT_REFERRALS, 0);
     // }
      //Bind b4 search if required
      if ( $ldapuserdn != '' && $ldappassword != '' ) {
         $ldapbind = @ldap_bind($ldapconn, $ldapuserdn, $ldappassword);
         if ( !$ldapbind ) {
         	log_message('error', "Failed to bind to LDAP server $ldapserver using $ldapuserdn/$ldappassword");
         	@ldap_close($ldapconn);
            return FALSE;
         }
      }
      if ( $return_attrs !== FALSE ) {
      	$returnvalues = $return_attrs;
      }
      else {
      $returnvalues = array($userattr);
      }
      //Look for the supplied user from LDAP to make sure it exists
      $filter = "($userattr=$username)";
      $sr = @ldap_search($ldapconn, $searchdn, $filter, $returnvalues);
      if ( !$sr ) {
      	@ldap_close($ldapconn);
      	return FALSE;
      }
      $info = @ldap_get_entries($ldapconn, $sr);
      if ( $info["count"] != 1 ) {
      	@ldap_close($ldapconn);
         return FALSE;
      }
      $entry = @ldap_first_entry($ldapconn,$sr);
      if (!$entry) {
      	@ldap_close($ldapconn);
         return FALSE;
      }
      $ldap_user_dn = @ldap_get_dn($ldapconn, $entry);
      //echo $ldap_user_dn;
      //var_dump($info); exit;
      if ( !$ldap_user_dn ) {
      	@ldap_close($ldapconn);
         return FALSE;
      }

      //Found the user in LDAP already but needs to check the user password
      $retlogin = @ldap_bind($ldapconn, $ldap_user_dn, $password);
      if ( $retlogin ) {
      @ldap_close($ldapconn);
      	if ( $return_attrs === FALSE ) {
      		//No need to ghet anything from LDAP
         return TRUE;
      	}
      	else {
				return $info;
      	}
      }
      @ldap_close($ldapconn);
      return FALSE;
   }

   private function _check_ldap_lib() {
   	if ( function_exists('ldap_connect') ) {
   		return TRUE;
   	}
   	osa_errorlog(__METHOD__ . ' - PHP LDAP library is missing.');
   	return FALSE;
   }
}

?>