<?php
/**
 * access_factory.php - Gets the access properties. Hard coded for now, but can change to DB later.
 *
 * @author $Author: dtong $
 * @version $Id: access_factory.php,v 1.20 2010/11/16 06:01:17 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class OSA_AccessFactory {

   public static function factory($type, $guestname) {
      $obj = self::getBase();
      switch ( $type ) {
         case 'admin':
	         $obj->admin_assign_editor = TRUE;
				$obj->admin_system_management = TRUE;
				$obj->admin_unit_write = TRUE;
				$obj->admin_learningtarget_write = TRUE;
				$obj->admin_course_description_write = TRUE;
				$obj->course_description_read = TRUE;
				$obj->course_description_write = TRUE;
				$obj->course_learningtarget_read = TRUE;
				$obj->course_learningtarget_write = TRUE;
				$obj->unit_read = TRUE;
				$obj->unit_write = TRUE;
				$obj->version_access = TRUE;
				$obj->homepage_access = TRUE;
				//$obj->ict_sample_upload = TRUE;
				//$obj->admin_ict_sample_upload = TRUE;
				$obj->admin_loginas = TRUE;
				$obj->course_hide_access = TRUE;
				$obj->unit_hide_access = TRUE;
				$obj->admin_goal_write = TRUE;
				$obj->admin_ict_write = TRUE;
				$obj->goal_read = TRUE;
				$obj->survey_write = TRUE;
				$obj->survey_admin_write = TRUE;
            break;
         case 'admin_read':
         	$obj->admin_assign_editor = FALSE;
            $obj->admin_system_management = FALSE;
            $obj->admin_unit_write = FALSE;
            $obj->admin_learningtarget_write = FALSE;
            $obj->admin_course_description_write = FALSE;
            $obj->course_description_read = TRUE;
            $obj->course_description_write = TRUE;
            $obj->course_learningtarget_read = TRUE;
            $obj->course_learningtarget_write = TRUE;
            $obj->unit_read = TRUE;
            $obj->unit_write = FALSE;
            $obj->version_access = TRUE;
            $obj->homepage_access = TRUE;
            $obj->admin_goal_readonly = TRUE;
            $obj->goal_read = TRUE;
            $obj->survey_write = TRUE;
            break;
         //case 'ict':
         	//$obj->ict_sample_upload = TRUE;
         	//Inherit all the teacher access too
         case 'teacher':
            $obj->admin_assign_editor = FALSE;
            $obj->admin_system_management = FALSE;
            $obj->admin_unit_write = FALSE;
            $obj->admin_learningtarget_write = FALSE;
            $obj->admin_course_description_write = FALSE;
            $obj->course_description_read = TRUE;
            $obj->course_description_write = TRUE;
            $obj->course_learningtarget_read = TRUE;
            $obj->course_learningtarget_write = TRUE;
            $obj->unit_read = TRUE;
            $obj->unit_write = TRUE;
            $obj->version_access = TRUE;
            $obj->homepage_access = TRUE;
            $obj->goal_read = TRUE;
            $obj->survey_write = TRUE;
            break;
         case $guestname:
         	$obj->admin_assign_editor = FALSE;
            $obj->admin_system_management = FALSE;
            $obj->admin_unit_write = FALSE;
            $obj->admin_learningtarget_write = FALSE;
            $obj->admin_course_description_write = FALSE;
            $obj->course_description_read = TRUE;
            $obj->course_description_write = FALSE;
            $obj->course_learningtarget_read = TRUE;
            $obj->course_learningtarget_write = FALSE;
            $obj->unit_read = TRUE;
            $obj->unit_write = FALSE;
            $obj->version_access = FALSE;
            $obj->homepage_access = FALSE;
            break;
         default:
         	// The base should have no access at all so it is fine to return just that
      }
      return ($obj);
   }

   public static function getBase() {
      $obj = new stdClass();
	   //Admin function can assign teachers to be a course editor
	   $obj->admin_assign_editor = FALSE;
	   //Admin function can manage user accounts
	   $obj->admin_system_management = FALSE;
	   //admin function can write to all units, targets and descriptions
	   $obj->admin_unit_write = FALSE;
	   //Can read all units including editing units, not implemented yet
	   $obj->admin_unit_read = FALSE;
	   $obj->admin_learningtarget_write = FALSE;
	   $obj->admin_course_description_write = FALSE;
	   //Can read course description
	   $obj->course_description_read = FALSE;
	   //User can write course description to courses that are assigned as editor
	   $obj->course_description_write = FALSE; //This is course based and needs editor assignment
	   //Users can read all learning targets
	   $obj->course_learningtarget_read = FALSE;
	   //Users can write to learning targets for courses assigned as editor
	   $obj->course_learningtarget_write = FALSE; //This is course based and needs editor assignment
	   //Can read all units
	   $obj->unit_read = FALSE;
	   //User can write to units to courses assigned as editors
	   $obj->unit_write = FALSE;
	   //User can access archived unit versions
	   $obj->version_access = FALSE;
	   $obj->homepage_access = FALSE;
	   //$obj->ict_sample_upload = FALSE;
	   //$obj->admin_ict_sample_upload = FALSE;
	   //Admin can access login as another user
	   $obj->admin_loginas = FALSE;
	   $obj->course_hide_access = FALSE;
	   $obj->unit_hide_access = FALSE;
	   $obj->admin_goal_write = FALSE;
	   $obj->admin_goal_readonly = FALSE;
	   //Can edit/write any ict, gc or tail
	   $obj->admin_ict_write = FALSE;
	   //Users can read goal
	   $obj->goal_read = FALSE;
	   $obj->survey_write = FALSE;
	   $obj->survey_admin_write = FALSE;
	   return $obj;
   }
}

?>