<?php
/**
 * user_model - Model for add/update/delete user
 *
 * @author $Author: dtong $
 * @version $Id: user_model.php,v 1.19 2011/05/16 08:11:48 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class user_model extends CI_Model {
	function __construct() {
		parent::__construct();
    }
/*
	function get_alluser($user_enabled,$filter=FALSE) { // 1:enabled
		$sql  = "select u.displayname,u.id,u.sis_teacher_number,u.username,u.firstname,u.lastname,u.middlename,u.enabled, ac.name access, au.type auth,d.name department ";
	    $sql .=" from user u ";
	    $sql .=" left join department d on u.department_id=d.id and d.enabled=".CMS_ADMIN_ENABLE ;
	    $sql .=" left join access ac on u.accessid=ac.id ";
	    $sql .=" left join auth au on u.auth_id=au.id ";
	    $where = " where u.id <>''";

	    if ($user_enabled!=CMS_ADMIN_ALL){
	    $where .= " and u.enabled =" . $user_enabled;
	    }

		if ($filter !== FALSE) {
	    	//$where .=  " and concat(u.firstname,' ',u.lastname,' ',u.middlename,' ', u.displayname) like '%{$filter}%' ";
	    	$where .=  " and (u.firstname like '%{$filter}%' or u.lastname like '%{$filter}%' or u.displayname like '%{$filter}%' or u.middlename like '%{$filter}%')";
	    //$where .=  " and  ((u.displayname is not null and u.displayname != '' and u.displayname  like '%{$filter}%' )  or
						//	((u.displayname is null or u.displayname = '') and  concat(u.firstname , ' ' , u.lastname) like '%{$filter}%' ) ) ";
	    }

	    $order_by = " order by u.firstname,u.lastname";


	    $res = $this->db->query($sql.$where.$order_by);
		//$res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;

	   return $res->result();
	}
*/
   function get_alluser($user_enabled, $filter=FALSE) {
   	$user_table = $this->db->dbprefix('user');
   	$dept_table = $this->db->dbprefix('department');
   	$access_table = $this->db->dbprefix('access');
   	$auth_table = $this->db->dbprefix('auth');
   	$course_table = $this->db->dbprefix('course_sis');
   	$uc_table = $this->db->dbprefix('user_course');

		$sql = 'select u.displayname,u.id,u.sis_teacher_number,u.username,u.firstname,u.lastname,' .
				 	'u.middlename,u.enabled,ac.name access,au.type auth,d.name department,' .
					'c.id courseid,c.name coursename,uc.iseditor,c.enabled courseenabled,' .
					'u.lastlogin,u.lastfailedlogin ' .
	   		 "from $user_table u " .
	   		 "left join $dept_table d on u.department_id=d.id and d.enabled=" . CMS_DB_BOOLEAN_TRUE . ' ' .
	   		 "left join $access_table ac on u.accessid=ac.id " .
	   		 "left join $auth_table au on u.auth_id=au.id " .
				 "left join $uc_table uc on uc.userid=u.id " .
				 "left join $course_table c on c.id=uc.courseid";
		$where_cond = '';
		$and = '';
	   if ($user_enabled != CMS_ADMIN_ALL){
	    	$where_cond = "u.enabled=$user_enabled";
	    	$and = ' and';
	    }

		if ($filter !== FALSE) {
	    	$where_cond .=  "$and (u.firstname like '%{$filter}%' or u.lastname like '%{$filter}%' or " .
	    						 "u.displayname like '%{$filter}%' or u.middlename like '%{$filter}%')";
	    }
	    if ( $where_cond ) {
	    	$where_cond = "where {$where_cond}";
	    }
	    //$order_by = "order by u.firstname,u.lastname";
	    $sql .= " $where_cond order by u.id asc,uc.iseditor desc,coursename asc";
	    $res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;

	   return $res->result();
   }

	function get_user($userid=FALSE, $username=FALSE, $user_enabled=CMS_ADMIN_ENABLE) {
	////	if ( !is_numeric($userid) )
		//	return FALSE;

		/*$this->db->select('u.id, u.displayname, u.firstname, u.lastname, u.middlename,
				           u.sis_teacher_number, u.username, u.password, u.email, u.title,
				           u.enabled,u.department_id,u.accessid,u.auth_id,d.name department ');*/
		 $this->db->select('u.*,d.name department');
	    $this->db->from('user u');
	    $this->db->join('department d', 'u.department_id=d.id and d.enabled='.CMS_ADMIN_ENABLE, 'left');

	    if ($userid != FALSE  )
	        $this->db->where('u.id',$userid);

	    if ($username != FALSE  )
	        $this->db->where('u.username',$username);

		$res = $this->db->get();

		if ( $res->num_rows() != 1 )
			return FALSE;
		$rows = $res->result();
    	return $rows[0];
	}

	function get_department() {
		$this->db->select('id, name ');
	    $this->db->from('department');
	    $this->db->where('enabled',CMS_ADMIN_ENABLE);
	    $this->db->order_by('name');
	    $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;

		$deps = $res->result();
		$result = array();
		$result[0] =lang('admin_department_ddldefualt');
		foreach($deps as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;

	}

	function get_access() {
		$this->db->select('id, name ');
	    $this->db->from('access');
	    $this->db->order_by('name');
	    $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$accs = $res->result();
		$result = array();
		$result[0] = lang('admin_access_ddldefualt');
		foreach($accs as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;

	}
	function get_auth() {
		$this->db->select('id,type ');
	    $this->db->from('auth');
	    $this->db->order_by('id');
	    $res = $this->db->get();
			if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_auth_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->type;
		}
		return $result;
	}

	function add_user($data) {

		$this->db->insert('user', $data);
		return TRUE;
	}

    function update_user($userid,$data) {
		$this->db->where('id',$userid);
		return $this->db->update('user', $data);
	}

	function del_user($userid,$user_enabled) {
		$this->db->where('id',$userid);
		return $this->db->update('user', array('enabled'=>$user_enabled));

	}




}
?>