<?php
/**
 * strand_model - Model for add/update/delete strand
 *
 * @author $Author: dtong $
 * @version $Id: strand_model.php,v 1.14 2011/03/23 11:32:49 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class strand_model extends CI_Model {
	function __construct() {
		parent::__construct();
    }

	function get_allstrand($enabled, $type, $filter=FALSE,$departmentid=FALSE,$schoolid=FALSE,$_table=FALSE) { // 1:enabled
		 if (!osa_is_int($type)){
		 	return FALSE;
	    }
		 $school_table = $this->db->dbprefix('school');
		 if ($_table != FALSE)
			$school_table = $_table;
		 $sql  ='select s.departmentid,s.schoolid,s.id, sc.name school,d.name department,' .
		 		  'd.enabled department_enabled,s.type,s.data,s.enabled, s.importid';
	    $sql .=" from strand s";
	    $sql .=" left join $school_table sc on s.schoolid=sc.id";
	    //$sql .=" left join department d on s.departmentid=d.id and d.enabled=".CMS_ADMIN_ENABLE;
		 $sql .=" left join department d on s.departmentid=d.id";

	   //$where = " where s.type={$type} and d.enabled=".CMS_DB_BOOLEAN_TRUE;
	   $where = " where s.type={$type}";
		if ($departmentid!=FALSE){
	    	$where .= " and s.departmentid =" . $departmentid;
	    }
		if ($schoolid!=FALSE){
	    	$where .= " and s.schoolid =" . $schoolid;
	    }
		if ($enabled!=CMS_ADMIN_ALL){
			if ( empty($enabled) ) {
				//For disabled, show even if department is disabled
	    		$where .= ' and (s.enabled=' . CMS_DB_BOOLEAN_FALSE . ' or d.enabled=' . CMS_DB_BOOLEAN_FALSE . ')';
			}
			else {
				//IT Std, GC, TaIL etc is not related to department so ignore department.enabled flag when department is null
				$where .= ' and s.enabled=' . CMS_DB_BOOLEAN_TRUE . ' and (d.enabled=' . CMS_DB_BOOLEAN_TRUE .
							 ' or s.departmentid=0 or s.departmentid is null)';
			}
	    }

	 	if ($filter!=FALSE) {
	 		$where .= " and (s.data like '%$filter%')";
	 	}

	    $order_by = " Order by sc.name,d.name,s.data";
	    $res = $this->db->query($sql.$where.$order_by);

		if ( $res->num_rows() <= 0 )
			return FALSE;

		 return $res->result();
	}

	function get_strand($strandid) {
		if ( !is_numeric($strandid) )
			return FALSE;

		$this->db->select('id, schoolid, departmentid, type, importid,data, enabled'); //enable
		//$this->db->select('id, schoolid, departmentid, type, importid,data');
	    $this->db->from('strand');
	    $this->db->where('id',$strandid);

		$res = $this->db->get();
		if ( $res->num_rows() != 1 ) {
			return FALSE;
		}
		return $res->result();
	}

	function get_department($current_strandid=FALSE) {
		$this->db->select('id,name,enabled');
	    $this->db->from('department');
	    if ( !$current_strandid ) {
	    	$this->db->where('enabled',CMS_DB_BOOLEAN_TRUE);
	    }
	    $this->db->order_by('name');
	    $res = $this->db->get();
		if ( $res->num_rows() <= 0 ) {
			return FALSE;
		}
		$au = $res->result();
		//Make sure we present the department according to the current starnd even if it is disabled
		if ( $current_strandid ) {
			$strand = $this->get_strand($current_strandid);
				if ( is_array($strand) ) {
					$dept_id = $strand[0]->departmentid;
					$tmp = array();
					foreach ($au as $key=>$value) {
						if ( $value->enabled || $value->id == $dept_id) {
							$tmp[$key] = $value;
						}
					}
					$au = $tmp;
			}
		}
		$result = array();
		$result[0] = lang('admin_department_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function get_school($type=FALSE,$dep_schid=FALSE,$_table=FALSE) {
		$school_table = $this->db->dbprefix('school');
		if ($_table != FALSE)
			$school_table = $_table;
		$this->db->select('id,name ');
	   $this->db->from($school_table);
	   if ($_table != FALSE)
	   	$this->db->where ('type',$type);
	   if ($dep_schid!=FALSE)
	   	$this->db->where ('id',$dep_schid);
	   $this->db->order_by('name');
	   $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_school_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function add_strand($data) {

		$this->db->insert('strand', $data);
		return TRUE;
	}

    function update_strand($strandid,$data) {

		$this->db->where('id',$strandid);
		$this->db->update('strand', $data);
		return TRUE;
	}

	function del_strand($strandid,$strand_enabled) {
		$this->db->where('id',$strandid);
		$this->db->update('strand', array('enabled'=>$strand_enabled));
		return TRUE;
	}



}
?>