<?php
/**
 * loginas_model - Model for add/update/delete user
 *
 * @author $Author: dtong $
 * @version $Id: loginas_model.php,v 1.14 2011/05/16 11:09:40 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Loginas_model extends CI_Model {
	//This is the object property name for the LOGIN object to store the original user object
	private $userold = 'userold';

	function __construct() {
		parent::__construct();
        $this->load->model('auth/login_model');
        $this->load->model('admin/user_model');
    }

    function display_none() {
    	return 'display:none;';
    }
 	function display_block() {
    	return 'display:block;';
    }

    function refresh_login_session($username) {
    	$current_login = osa_login_object();
    	$db_user = $this->login_model->getDbUser($username);
    	if ( empty($current_login) || empty($db_user) ) {
    		return FALSE;
    	}
    	if ( $current_login->username != $db_user->username ) {
    		return FALSE;
    	}
    	/*
    	$userold_var = $this->userold;
    	if ( property_exists($current_login, $userold_var) ) {
    		//Retain original user if this is a loginas session
			$db_user->$userold_var = $current_login->$userold_var;
    	}*/
    	//This will retain any properties not coming from the DB
    	foreach ($db_user as $key => $value) {
    		$current_login->$key = $value;
    	}
    	osa_login_object_set($current_login);
    	return TRUE;
    }

    function loginas($username, $loginas) {
    	$userold_var = $this->userold;
    	if ( $loginas == CMS_ADMIN_ENABLE ) {
    		//To login as another user
	    	if ( $this->access_model->checkaccess_any_noexit('admin_loginas') ) {
	    		$userold = $this->login_model->getLogin();
	    		//$usernew = $this->user_model->get_user(FALSE, $username);
	    		$usernew = $this->login_model->getDbUser($username);
	    		//TODO: seems it is not deleting the cookies here
	    		osa_del_treecookies();
	    		$temp = $usernew;
	    		//Saves the original usename in the login session object
	    		//TODO: don't use username and use user id
	    		$temp->$userold_var = $userold;
	    		osa_login_object_set($temp);
	    	}
	    	else {
	    		echo osa_ajaxmsg('no access loginas error');
	    		return FALSE;
	    	} // check enable user
    	}
    	else { //Switch back to admin user
    		//Gets the current user object which should contain the original
    		//user object in userold property.
    		$current_user = $this->login_model->getLogin();
    		if ( property_exists($current_user, $userold_var) && is_object($current_user->$userold_var) ) {
    			osa_login_object_set($current_user->$userold_var);
    			osa_del_treecookies();
    		}
    		else {
    			//Ok, we got a problem or a hack here so just destroy the LOGIN session and redirect to home/login page
    			$this->login_model->destroyLogin();
    			redirect('home');
    			exit;
    		}
    	}
    	$this->load->library('cms/cms_security');
    	$this->cms_security->clear_tokens();
    	redirect('home');
    	exit;
    }
/*
	function access_loginas() {
		$nowuser = $this->login_model->getLogin();
		//$access  = $this->access_model->getObj($nowuser->access_name);
		$hide = '';
		if ( !$this->access_model->checkaccess_any_noexit('admin_loginas') ) {
			$hide = $this->display_none();
		}

		return $hide;
	}
*/
	function check_sameuser( $userid ) {
		$nowuser = $this->login_model->getLogin();
		$hide = '';
		if ($nowuser->id==$userid)
   		$hide = $this->display_none();
   	return $hide;
	}

	function check_userauth( $auth_id ) {
		$hide = '';
		//If we have new auth object that needs password then this has to be changed
		if ($auth_id != CMS_AUTH_ID_LOCAL )
    	    $hide = $this->display_none();
		return $hide;
	}
}
?>