<?php
/**
 * grade_model.php - Model file for admin grade config
 *
 * @author $Author: wichai $
 * @version $Id: grade_model.php,v 1.2 2011/02/23 09:14:04 wichai Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

Class Grade_model extends CI_Model{
	//Tables with mingradeid and maxgradeid columns
	private $tables_minmax = array('course_sis', 'benchmark', 'category');
	//Tables with gradeid column
	private $tables_gradeid = array('display_grade', 'course_grade');


	function __construct(){
		parent::__construct();
	}

	function get_all_grades(){
		$this->db->select('grad.*, schl.name AS school_name , schl.id as school_id');
		$this->db->from('grade grad');
		$this->db->join('school schl', 'grad.schoolid = schl.id', 'left');
		$this->db->order_by('sort asc, name asc');
		$resobj = $this->db->get();
   	return $resobj->result();
	}

	function get_grade($id){
		$this->db->select('*');
		$this->db->where('id', $id);
		$resobj = $this->db->get('grade');
		return $resobj->result();
	}

	function get_all_schools(){
		$this->db->select('id, name');
		$resobj = $this->db->get('school');
		if ( $resobj-> num_rows() <= 0 ){
			return FALSE;
		}
		$school = $resobj->result();
		$result = array();
		// Add default sentence on the top of dropdown array
		$result[0] = lang('admin_grade_dropdown_default');
		foreach ( $school as $value ){
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function update_grade($id, $data){
		$this->db->where('id', $id);
		return $this->db->update('grade', $data);
	}

	function insert_grade($data){
		return $this->db->insert('grade', $data);
	}

	function delete_grade($id){
		$this->db->where('id', $id);
		return $this->db->delete('grade');
	}

	//True - grade relationship does exist, false - Grade is not used anywhere
	function check_grade_relation_exists($gradeid) {
		$all = $this->get_grade_count_array();
		return (array_key_exists($gradeid, $all));
	}

	private function get_grade_count_array() {
		static $total = NULL;
		if ( $total === NULL ) {
			$total = array();
			foreach($this->tables_gradeid as $table) {
				$total = $this->my_merge($total, $this->grade_usage_array($table, TRUE));
			}
			foreach($this->tables_minmax as $table) {
				$total = $this->my_merge($total, $this->grade_usage_array($table));
			}
		}
		return $total;
	}

	private function my_merge($total, $new) {
		foreach($new as $record) {
			if ( array_key_exists($record->id, $total) ) {
				$total[$record->id] += $record->grade_count;
			}
			else {
				$total[$record->id] = $record->grade_count;
			}
		}
		return $total;
	}

	private function grade_usage_array($table, $compare_gradeid_column=FALSE, $gradeid=FALSE) {
		if (!$table){
			return FALSE;
		}
		$this->db->select('g.id, count(g.id) grade_count');
		$this->db->from("grade g");
		if ( !$compare_gradeid_column ) {
			$this->db->join("$table t", 'g.id=t.mingradeid OR g.id=t.maxgradeid');
		}
		else {
			$this->db->join("$table t", 'g.id=t.gradeid');
		}
		if( !$gradeid ){
			$this->db->group_by('g.id');
		}
		else {
			$this->db->where('g.id', $gradeid);
		}
		$resobj = $this->db->get();
   	return $resobj->result();
	}
}