<?php
/**
 * category_model.php - Model file for admin category config
 *
 * @author $Author: dtong $
 * @version $Id: category_model.php,v 1.6 2011/03/21 06:53:17 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

Class Category_model extends CI_Model {

	function __construct(){
		parent::__construct();
	}

	//function for the index page
	function get_all_category_department($filter){
		$this->db->select('c.name as c_name,g1.name as maxgrade, g2.name as mingrade, c.enabled as c_enabled,
								 d.name as dp_name, cd.departmentid as dp_id, c.id as c_id, c.sort as c_sort');
		$this->db->from('category c');
		$this->db->join('category_department cd', 'cd.categoryid=c.id', 'left');
		$this->db->join('department d', 'cd.departmentid=d.id and d.enabled=1', 'left');
		$this->db->join('grade g1', 'c.maxgradeid=g1.id');
		$this->db->join('grade g2', 'c.mingradeid=g2.id');
		if ( $filter == CMS_ADMIN_ENABLE ) {
			$this->db->where('c.enabled =' . CMS_ADMIN_ENABLE .' or d.id = null');

		}
		else if ( $filter == CMS_ADMIN_DISABLE ) {
			$this->db->where('c.enabled =' . CMS_ADMIN_DISABLE .' or d.id = null');
		}
		//else {
			//$this->db->where('d.enabled', CMS_DB_BOOLEAN_TRUE);
			//$this->db->or_where('d.id', NULL);
		//}
		$this->db->order_by('c.sort', 'asc');
		$this->db->order_by('dp_name', 'asc');
		$resobj = $this->db->get();
		return $resobj->result();
	}

	function get_category_department($catgory_id) {
		$this->db->select('c.name as c_name,g1.id as maxgrade, g2.id as mingrade, c.enabled as c_enabled,
								 d.name as dp_name, cd.departmentid as dp_id, c.id as c_id, c.sort as c_sort');
		$this->db->from('category c');
		$this->db->join('category_department cd', 'cd.categoryid=c.id', 'left');
		$this->db->join('department d', 'cd.departmentid=d.id', 'left');
		$this->db->join('grade g1', 'c.maxgradeid=g1.id');
		$this->db->join('grade g2', 'c.mingradeid=g2.id');
		$this->db->where('c.id', $catgory_id);
		$catobj = $this->db->get();
		if ( $catobj->num_rows() <= 0 ) {
			return FALSE;
		}
		$res = $catobj->result();
		return $res;
	}

	function get_sort_category(){
		$cateobj = $this->db->get('category');
		$category = $cateobj->result();
		$result = array();
		foreach($category as $value) {
			$result[$value->id] = $value->sort;
		}
		return $result;
	}

	//Function for the edit page
	function get_all_departments($get_disabled=FALSE){
		if ( !$get_disabled ) {
			$depobj = $this->db->get_where('department', array('enabled'=>CMS_DB_BOOLEAN_TRUE));
		}
		else {
			//Get all including disabled ones, the controller will decide what not to display
			$depobj = $this->db->get('department');
		}
		$departments = $depobj->result();
		foreach ($departments as $value) {
			if ( !$get_disabled ) {
				$result[$value->id] = $value->name;
			}
			else {
				//We need the full record so we know disabled or not
				$result[$value->id] = $value;
			}
		}
		return $result;
	}

	function get_all_grades(){
		$this->db->select('*');
		$this->db->from('grade');
		$this->db->order_by('sort', 'asc');
		$gradeobj = $this->db->get();
		return $gradeobj->result();
	}

	function get_name_grades(){
		$grades = $this->get_all_grades();
		$result = array();
		$result[0] = lang('admin_category_dropdown_default');
		foreach ($grades as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function get_sort_grades(){
		$grades = $this->get_all_grades();
		$result = array();
		foreach($grades as $value) {
			$result[$value->id] = $value->sort;
		}
		return $result;
	}

	// return array $dept_id
	function get_departmentid_by_category($category_id){
		$this->db->select('departmentid');
		$this->db->where('categoryid', $category_id);
		$getdep = $this->db->get('category_department');
		$deparementobj= $getdep->result();
		$dept_id = array();
		foreach ($deparementobj as $result) {
			$dept_id[] = $result->departmentid;
		}
		return $dept_id;
	}

	function insert_category($postdata){
		$this->db->set('mingradeid', $postdata['mingradeid']);
		$this->db->set('maxgradeid', $postdata['maxgradeid']);
		$this->db->set('enabled', $postdata['enabled']);
		$this->db->set('name',  $postdata['name']);
		$this->db->set('sort',  $postdata['sort']);
		$this->db->insert('category');
		// check last insert id and add into category_department table
		$category_latest_id = osa_db_lastinsertid($this->db);
		if ( !$category_latest_id ) {
			return FALSE;
		}
		$dept_id = array();
		$dept_id = $postdata['dapartmentid'];
		if ( isset($dept_id) ) {
			foreach ($dept_id as $result) {
				$this->db->set('departmentid', $result);
				$this->db->set('categoryid', $category_latest_id);
				$this->db->insert('category_department');
			}
		}
		else {
			return FALSE;
		}
	}

	function update_category($category_id, $category_enabled, $postdata){
		$existing_deptid = $this->get_departmentid_by_category($category_id);
		$newpost_deptid = array();
		$newpost_deptid = $postdata['dapartmentid'];
		// if existing deparement id not equal new one: delete old id and add the new one
		if ($existing_deptid != $newpost_deptid) {
			// delete
			$this->db->where('categoryid', $category_id);
			$this->db->delete('category_department');
			// add
			foreach ($newpost_deptid as $result) {
				$this->db->set('departmentid', $result);
				$this->db->set('categoryid', $category_id);
				$this->db->insert('category_department');
			}
		}
		$data = array(
               'mingradeid' => $postdata['mingradeid'],
               'maxgradeid' => $postdata['maxgradeid'],
               'enabled' => $category_enabled,
					'name' => $postdata['name'],
					'sort' => $postdata['sort']);
		$this->db->where('id', $category_id);
		$this->db->update('category', $data);
	}

	// update enable/disable field
	function enabled($category_id, $action) {
		$set_array = array( 'enabled' => $action );
		return $this->db->update('category', $set_array, "id = {$category_id}");
	}

}