<?php
/**
 * admin_user_role_model.php - Model for get data table (user_role,user),insert and delete table user_role.
 *
 * @author $Author: Samarth
 * @version $Id: admin_user_role_model.php
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/
class admin_user_role_model extends CI_Model {
	function __construct() {
		parent::__construct();
    }
    //funtion get user role by  type
   function get_user_role($type, $schoolid, $departmentid) {
		$table_user_role = $this->db->dbprefix('user_role');
		$table_user = $this->db->dbprefix('user');
		$this->db->select('ur.id roleid,ur.userid,u.displayname,u.firstname,u.lastname');
		$this->db->from($table_user_role.' ur');
	   $this->db->join($table_user.' u', 'ur.userid=u.id', 'left');
	   $this->db->where('type',$type);
	   $this->db->where('schoolid',$schoolid);
	   $this->db->where('departmentid',$departmentid);
	   //$this->db->order_by('u.displayname,u.firstname,u.lastname');
		$res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$users = $res->result();
		osa_sort_user_displayname($users);
		return $users;
   }
    //funtion get user by not in user role
	function get_user($userrole_ids=FALSE) {
		$table_user = $this->db->dbprefix('user');
		$this->db->select('id, displayname,firstname,lastname');
		$this->db->from($table_user);
		$this->db->where('enabled',CMS_ADMIN_ENABLE);
		if (isset($userrole_ids) && $userrole_ids != FALSE && is_array($userrole_ids))
			$this->db->where_not_in('id', $userrole_ids);
		$this->db->where_not_in('username', array($this->config->item('cms_admin_username'),$this->config->item('cms_guest_username')));
		//$this->db->order_by('displayname,firstname,lastname');
		$res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$result = $res->result();
		osa_sort_user_displayname($result);
		$user = array();
		foreach($result as $value) {
			$user[$value->id] = osa_user_getname($value);
		}
		return $user;
	}
	//funtion add user role
	function insert_user_role($sql_data, $type, $schoolid, $departmentid, $group) {
		$table_user_role = $this->db->dbprefix('user_role');
		//$sql = "INSERT INTO $table_user_role (userid,type) VALUES ";
		//$this->db->query($sql . $sql_data );
		$fields = 'userid,type,schoolid,departmentid,grouping';
		$insert_data = ''; $comma = '';
		foreach($sql_data as $id) {
			if ( !is_numeric($id) && strtolower($id) != 'null' )
				continue;
			if ( $group != 'null' ) {
				$insert_data .= "{$comma}({$id},{$type},{$schoolid},{$departmentid},'{$group}')";
			}
			else {
				$insert_data .= "{$comma}({$id},{$type},{$schoolid},{$departmentid},{$group})";
			}
			$comma = ',';
		}
		if ( $insert_data == '' )
			return FALSE;
		$sql = "insert into $table_user_role ($fields) values $insert_data";
		return $this->db->query($sql);
	}
	//funtion delete user role
	function delete_user_role($roleid) {
		$table_user_role = $this->db->dbprefix('user_role');
	   $this->db->where('id',$roleid);
		$this->db->delete($table_user_role);
		return TRUE;
	}
}

