<?php
/**
 * uph_lt_extended.php - This LT object lists strands, standards, benchmarks and Learning Targets on the unit page.
 * 							 Most of the code here came from unit_lt. This supports importid sorting and display but unit_lt does not yet.
 * 							 unit_lt should support importid sorting and display later if necessary.
 *
 * @author $Author: dtong $
 * @version $Id: uph_lt_extended.php,v 1.7 2011/05/09 04:48:53 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/
require_once(APPPATH.'/libraries/unit/unit_base.php');

class uph_lt_extended extends unit_base {
	//Look ahead array for sorting
	private $look_ahead = FALSE;
	//Keeps track the previous data
	private $last_strandid = FALSE;
	private $last_standardid = FALSE;
	private $last_benchmarkid = FALSE;
	//Tells the current record is the first LT in the list or not
	private $lt_is_first_flag = TRUE;
	//Various cssid prefixes
	private $pre_strand = 'ltstr';
	private $pre_standard = 'ltsta';
	private $pre_benchmark = 'ltben';
	//Use cssid or not
	private $use_cssid = FALSE;

	function __construct() {
		parent::__construct();
		$this->CI->load->model('unit/lt_model');
		$this->CI->load->library('cms/cms_btnsort');
	}

	function render($data, $params) {
		if ( $data !== FALSE && $params !== FALSE ) {
			$this->reset($data, $params);
		}
		$pre_tar = CMS_MODULE_LEARNING_TARGETS;
		$cssid_tar = '';
		$this->use_cssid = FALSE;
		$this->html = '';
		//This will get all the strands, standards, benchmarks and importids.
	 	$this->CI->lt_model->sort_type = $this->sort_type;
	 	$this->CI->lt_model->sort_read_only = $this->sort_read_only;
	 	$this->CI->lt_model->sort_filehash = $this->get_template_filepart();
	 	$dbobjs = $this->CI->lt_model->get_targets($this->unitid(), $this->type(), TRUE);
	 	if ( $dbobjs === NULL ) {
	 		return osa_buildererror();
	 	}
		if ( $dbobjs ) {
			$lastcourseid = '';
			$this->html = '<div class="lt_body">';
			$this->color_track_reset();
			$select_array = $this->getval('_select1');
			$depts = $this->CI->lt_model->get_departments_bycourse('id', TRUE);

			//cssid for compare version highlight
			if (isset($params->use_cssid) && $params->use_cssid===TRUE)
				 $this->use_cssid = TRUE;

			$this->CI->load->model('unit/unit_model');
			$first_course = TRUE;
			//Set the look_ahead array, needed to know is a record last of the list or not.
			$this->set_lookahead_array($dbobjs);
			$count = 0; //Array $look_ahead starts with 0
			$this->last_strandid = FALSE;
			$this->last_standardid = FALSE;
			$this->last_benchmarkid = FALSE;
			$this->lt_is_first_flag = TRUE;

			foreach ($dbobjs as $record) {
				$count++;
				//get_department_display() uses cache so OK to use in a loop
				$show_dept = $this->CI->unit_model->get_department_display($record->courseid);
				if ($show_dept === FALSE) {
					$show_dept = $this->CI->select_model->get_department($depts ,$record->courseid );
				}
				/*if ( $this->CI->config->item('cms_lt_importid_support') ) {
					//Need to bold it due to all the colorful strands, standards etc.
					$show_dept = "<b>$show_dept</b>";
				}*/
				//First department or moving to a new department
				if ($lastcourseid =='' || $lastcourseid != $record->departmentid) {
				   $lastcourseid = $record->departmentid;
				   $this->html.= $show_dept;
				   $first_course = FALSE;
				   $this->last_strandid = FALSE;
					$this->last_standardid = FALSE;
					$this->last_benchmarkid = FALSE;
				}
				//Prints strands, standards and benchmarks
				$this->print_heading($record);
				if ($this->use_cssid) {
					$cssid_tar = "cssid='{$pre_tar}_{$record->id}'";
					$color = 'lt_item2';
				}
				else {
					$color = $this->color_track('lt_item1a', 'lt_item2a');
				}

				$this->html .= "<div class=\"$color\" $cssid_tar><table width=\"100%\" style=\"margin:0px\"><tr><td>";
				$data_target = $record->data;
					if ($params->courseid!=$record->courseid)
						$data_target = $data_target.' '.'<span class="course_lnk_link_title">'.'('.$record->coursename.')'.'</span>';
				$this->html .= "{$data_target}";
				// render discription (LT,S&S,SSK)
				if ( ($cattext = $this->getval('_category_bodytext')) !== FALSE ) {
					$this->html .= "<span style=\"margin-left:15px\">&nbsp;</span>";
					if ( ($catcolor = $this->getval('_category_color')) !== FALSE ) {
						$this->html .= "<nobr><font color=\"{$catcolor}\">{$cattext}</font></nobr>";
					}
					else {
						$this->html .= "<nobr>{$cattext}</nobr>";
					}
				}
				$this->html .= "</td>";
				$this->html .= '<td width="99" valign="middle" align="right" class="itembuttons"><nobr>';
				$this->html .= '<span class="lt_symbol">';
				if ( !is_null($record->select1) && $select_array !== FALSE && array_key_exists($record->select1, $select_array)) {
					$this->html .= $select_array[$record->select1];
				}
				$this->html.= '</span>';
				//Buttons
				if ( is_array($buttons = $this->getval('_button')) ) {
					$this->html .= '<span class="itembuttons">';
					$tmpparams = $this->params;
					$tmpparams->resid = $record->id; //assign the resource id

					$has_next_lt = $this->lt_has_next($record, $count);
					if ( $this->lt_is_first_flag && $has_next_lt ) { //First in a list
						$this->html .= $this->buttonsobj->render(
												$this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_FIRST,
												$record,$this->sort_type), $tmpparams);
						$this->lt_is_first_flag = FALSE;
					}
					elseif ($has_next_lt) { //next in a list
						$this->html .= $this->buttonsobj->render(
												$this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_MIDDLE,
												$record,$this->sort_type), $tmpparams);
					}
					elseif ( !$this->lt_is_first_flag && !$has_next_lt) { //Last in a list
						$this->html .= $this->buttonsobj->render(
												$this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_LAST,
												$record,$this->sort_type), $tmpparams);
						$this->lt_is_first_flag = TRUE; //Sets it for the next record
					}
					//No sort buttons for single record in a list
					$this->html .= $this->buttonsobj->render($buttons, $tmpparams);

					$this->html .= '</span></nobr></td>';
				}//Buttons
				else {
					//$this->html .= '<td class="itembuttons"></td>';
					$this->html .= '</nobr></td>';
				}
				$this->html .= '</tr></table></div>';
				//$this->lt_is_first_flag = FALSE;
			}
			$this->html .= '</div>';
		}
		return $this->html;
	}

	//We create a duplicated data array so we can look ahead for the sort buttons.
	//Need to know when is the last or the only one LT in a benchmark.
	//The DB array should be indexed already but just do this and make sure
	private function set_lookahead_array($array) {
		$this->look_ahead = array();
		if ( !is_array($array) )
			return FALSE;
		$this->lookahead = array();
		$count = 0;
		foreach($array as $record) {
			$this->look_ahead[$count++] = $record;
		}
	}

	//Tells do we have another LT belonging to the same benchmark
	private function lt_has_next(&$record, $count) {
		$total = count($this->look_ahead);
		if ( $total <= $count )
			return FALSE;
		$next_record = $this->look_ahead[$count];
		if ( $next_record->benchmarkid == $record->benchmarkid )
			return TRUE;
		return FALSE;
	}

	//Prints the strands, standards and benchmarks
	private function print_heading(&$record) {
		if ( $record->strandid != $this->last_strandid ) {
			$this->last_strandid = $record->strandid;
			$cssid_str = "cssid='{$this->pre_strand}{$this->type()}_{$record->strandid}'";;
			$strand = $record->strand;
			if ( $this->CI->config->item('cms_lt_importid_support') ) {
				$strand = "$record->strand_importid $record->strand";
			}
			$this->html .= "<div class=\"sb_strand\" $cssid_str>" . $this->getval('_strand_title') . ": {$strand}</div>";
		}
		if ( $record->standardid != $this->last_standardid ) {
			$this->last_standardid = $record->standardid;
			$cssid_str = "cssid='{$this->pre_standard}{$this->type()}_{$record->standardid}'";
			$standard = $record->standard;
			if ( $this->CI->config->item('cms_lt_importid_support') ) {
				$standard = "$record->standard_importid $record->standard";
			}
			$this->html .= "<div class=\"sb_std\" $cssid_str>" . $this->getval('_standard_title') . ": {$standard}</div>";
		}
		if ( $record->benchmarkid != $this->last_benchmarkid ) {
			$this->last_benchmarkid = $record->benchmarkid;
			$cssid_str = "cssid='{$this->pre_benchmark}{$this->type()}_{$record->benchmarkid}'";
			$benchmark = $record->benchmark;
			if ( $this->CI->config->item('cms_lt_importid_support') ) {
				$benchmark = "$record->benchmark_importid $record->benchmark";
			}
			$this->html .= "<div class=\"sb_bench2\" $cssid_str>" . $this->getval('_bench_title') . ": {$benchmark}</div>";
		}
	}
}