<?php
/**
 * uph_entry_point_completion_date.php -
 *
 * Unit process handle for embedding a date on the template. For Goal entry points only
 * *** This is depricated, only ISB is using it right now. ***
 *
 * @author $Author: dtong $
 * @version $Id: uph_entry_point_completion_date.php,v 1.5 2011/04/18 11:39:58 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

require_once(APPPATH.'/libraries/unit/unit_base.php');
class uph_entry_point_completion_date extends unit_base {

	function render($data, $params) {
		//Make sure the data types are correct
		if ( !is_array($data) || !is_object($params) ) {
			osa_errorlog(__METHOD__ . ' - Input data or params is not set.', array($data, $params));
			echo osa_buildererror();
			return FALSE;
		}
		//Make sure we have the action
		if ( !isset($params->action) || !is_string ($params->action) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no action.', $this->params);
			echo osa_buildererror();
			return FALSE;
		}
		//Make sure we have the unitid
		if ( !isset($params->unitid) || !is_string ($params->unitid) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no unitid.', $this->params);
			echo osa_buildererror();
			return FALSE;
		}

		$html = '';
		$html .= '<div class="goal_title_date" >' . $this->getval('_title',$data) . '&nbsp;';
		$_typeid = $this->getval('_typeid', $data);
		$is_goal_edit = $this->CI->goal_model->is_edit_goal($params->unitid);
		$entry_point = $this->get_completion_date($params->unitid);
		$completedate = '';
		if ( isset($entry_point->completedate) && $entry_point->completedate != FALSE )
			$completedate = osa_date_format($entry_point->completedate);

		if ( $params->action == CMS_ACTION_EDIT  && $is_goal_edit) {
			$html .= $this->render_write($data,$completedate,$params);
		}
		elseif ( $params->action == CMS_ACTION_READ ){
			$html .= $this->render_read($completedate,$_typeid,$params->unitid);
		}
		else{
			return '';
		}
		$html .= '</div>';
		return $html;
	}
	//Function render completion date readonly.
	private function render_read($completedate,$_typeid,$extid){
		$cssid = $_typeid.'_'.$extid;
		$html = "<span class='goal_completedate' cssid='$cssid'>{$completedate}</span>";
		return $html;
	}
	//Function render completion date write and read.
	private function render_write($data,$completedate,$params){
		$button = $this->getval('_button',$data);
		$_typeid = $this->getval('_typeid', $data);
		$html_type = $this->getval('_html_type',$button);
		$image = $this->getval('_image',$button);
		$link = $this->getval('_link', $button);
		//image
		if ( $image ) {
			if ( ($alt_title = $this->getval('_alt_title', $button)) !== FALSE )
				$alt_title = "title=\"$alt_title\"";
			else
				$alt_title = "";

			$image_id = "";
			if ( ($image_id = $this->getval('_image_id', $button)) !== FALSE )
				$image_id = "id=\"$image_id\"";

			$image = "<img {$image_id} {$alt_title} src=\"" . osa_imagepath() . $image . '" border="0" />';
		}
		else {
			$image = '';
		}

		$link = str_replace(parent::UNITID_PATTERN, $params->unitid . '/' . $_typeid, $link);
		$href = '';
		if ( $link != '' && $link != FALSE )
			$href = "href=\"{$link}\"";
		//jscript
		if ( ($jscript = $this->getval('_jscript',$button)) !== FALSE ) {
			$jscript = str_replace(parent::UNITID_PATTERN, $params->unitid . '/' . $_typeid, $jscript);
			if ( ($jevent = $this->getval('_jevent',$button)) !== FALSE && $jevent != '') {
				$jscript = ' '  .$jevent . '="' . $jscript . '" ';
			}
			else{
				$jscript = ' onclick="' . $jscript . '" ';
			}
		}
		else {
			$jscript='';
		}
		$id = '';
		$name = '';
		$readonly = '';
		$size = '';

		$id = "id='{$this->getval('_html_id', $button)}'";
		$name = "name='{$this->getval('_html_id', $button)}'";
		$size = "size='{$this->getval('_html_size', $button)}'";
		$value =  "value='{$completedate}'";
		if ( ($html_readonly = $this->getval('_html_readonly', $button)) !== FALSE && $html_readonly != '' ) {
			  $readonly = "readonly='readonly'";
		}
		$html = "<input type='$html_type' $id $name $size $readonly $value $jscript />&nbsp;";
		$html .= " <a $href class=\"buttonalink\" {$jscript}>{$image}</a>";
		return $html;
	}
	//Function Get completion date in entry_point table.
	private function get_completion_date($goalid) {
		$entry_point = FALSE;
		if ( isset($goalid) && $goalid != FALSE )
			$entry_point = $this->CI->goal_model->get_entry($goalid);
		return $entry_point[0];
	}


}