<?php
/**
 * unit_title.php - Handles title and subtitle types
 *
 * @author $Author: dtong $
 * @version $Id: unit_title.php,v 1.25 2011/05/10 16:11:55 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_title extends unit_base {

	function __construct() {
		parent::__construct();
	}

	function render($data, $params) {
		$this->reset();
		$this->data = & $data;
		$this->params = $params;

		switch ($data['_type']) {
			case 'title':
				$this->do_title();
				break;
			case 'title_big_wb':
				$this->do_title_big_wb();
				break;
			case 'subtitle':
				$this->do_subtitle();
				break;
			default:
				$this->error(__METHOD__ . ' - Invalid type.', $data);
		}
		return $this->html;
	}

	private function do_title() {
		$this->html .= '<div class="stagetitle">' . $this->data['_title'] . '</div>';
		return TRUE;
	}

	//Same as title but with more height and border
	private function do_title_big_wb() {
		$this->html .= '<div class="stagetitle_big_wb">' . $this->data['_title'] . '</div>';
		return TRUE;
	}

	private function do_subtitle() {
		/*
		$space = '&nbsp;';
		$class = 'subtitle_text';
		if (isset($this->params->unit_compare) && $this->params->unit_compare !== FALSE) {
			$class = 'subtitle_text_compare';
			$space = '';
		}*/
		$class_subtitle = 'class="subtitle_text"';
		if ( ($action = $this->getval('_action')) !== FALSE && $action == CMS_ACTION_READ )
			$class_subtitle = 'class="subtitle_text_read"';

		$this->html .= '<div style="width:100%;">';
		if ( ($value = $this->getval('_title')) !== FALSE )
			$this->html .= '<table border="0" width="100%"><tr><td '.$class_subtitle.'>'.$value;
		//Looks like someone just took out all the buttons when it is read action
		//may be it was done for PDF but unit_button is coded with PDF in mind so safe to run the buttons
		//since buttons can be needed for action read like reflection, misunderstadning etc.
		//if ( $action != CMS_ACTION_READ )
		$this->do_leftbuttons();

		$this->html .= "</td>";
		//if ( $action != CMS_ACTION_READ )
		$this->do_rightbuttons();

		$this->html .= "</tr></table>";

		$this->html .= "</div>";

		return TRUE;
	}

	private function do_rightbuttons() {
		if ( ($buttons = $this->getval('_rightbutton')) === FALSE )
			return FALSE;
		if ( !is_array($buttons) ) {
			$this->error(__METHOD__ . ' - Invalid buttons array', $buttons);
			return FALSE;
		}
		$html = $this->buttonsobj->render($buttons, $this->params);
		if ( $html && $html != '' ) {
			 $html =  '<td width="20%" style="text-align:right;">' . $html . '</td>';
			$this->html .= $html;
		}
		return TRUE;
	}

	private function do_leftbuttons() {
		if ( ($buttons = $this->getval('_leftbutton')) === FALSE )
			return FALSE;
		if ( !is_array($buttons) ) {
			$this->error(__METHOD__ . ' - Invalid buttons array', $buttons);
			return FALSE;
		}
		$html = $this->buttonsobj->render($buttons, $this->params);
		if ( $html && $html != '' ) {
			$html = '<span>' .$html . '</span>';
			//$html = '<div class="leftbuttons">' .$html . '</div>';
			$this->html .= $html;
		}
		return TRUE;
	}
}
?>