<?php
/**
 * unit_resource.php - Manage unit resource data and UI
 *
 * @author $Author: dtong $
 * @version $Id: unit_resource.php,v 1.59 2011/05/23 03:06:42 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_resource extends unit_base {
	private $max_selects=0;
	private $orig_data=NULL;
	private $user = NULL;
	private $pdf_private_resource = FALSE;
	private $static_res = FALSE;

	function __construct () {
		parent::__construct();
		$this->max_selects = $this->CI->config->item('cms_max_selects');
		$this->orig_data = $this->data;
		$this->user = & osa_login_object();
		$this->pdf_private_resource_support = $this->CI->config->item('cms_pdf_private_resource_select');
		$this->CI->load->model('unit/resource_model');
	}

	function render($data, $params) {
		global $g_pdf_mode;
		if ( $data !== FALSE && $params !== FALSE ) {
			$this->reset($data, $params);
			$this->orig_data = &$this->data;
		}
		$this->html = '';

		//$sortflag = $this->getval('_sort_flag');
		//////////////////////////////////////////////////
		//TODO: Should take out linkunit ASAP
		$use_linkunit = $this->getval('_use_linkunit');
		/////////////////////////////////////////////////
/*
		/////////////////////////////////////////////////////////////////////////
		//TODO: The logic here should go away ASAP, linkunit issue
		if ($sortflag) {
			//TOxDO: Now we have 3 different model function doing very similiar job, very messy. Need to fix this.
			if ($use_linkunit != FALSE)
				 $res = $this->CI->sort_model->get_linkunit_resources($this->params->unitid,$this->getval('_typeid'));
			else
				 $res = $this->CI->sort_model->get_resources($this->params->unitid, $this->getval('_typeid'));
		}
		else {
			$this->CI->load->model('unit/resource_model');
			//_date_sort only works when _sort_flag is false
			//$date_sort = $this->getval('_date_sort');
			//$res = $this->CI->resource_model->get_resources($this->params->unitid, $this->getval('_typeid'), $date_sort);
		}
*/
		//Save the original unitid incase we need it for static resources
		$unitid = $orig_unitid = $static_unitid = $this->params->unitid;
		$this->static_res = $this->getval('_static');
		$template_file_part = $this->get_template_filepart();
		$res = $this->CI->resource_model->get_resources($unitid,
				 	$this->getval('_typeid'), $template_file_part, $this->static_res);
		if ( $this->static_res && $res && count($res) > 0 ) {
			//Get the actual static unitid
			$current = reset($res);
			$unitid = $current->unitid;
			//Need to turn off prefetch for this static resource
			$this->CI->load->library('cms/cms_prefetch');
			//Static is different and can not be compared, also turn off edit for unit compare
			if ( $params->use_cssid ) {
				$params->action = 'read';
			}
			$params->use_cssid = FALSE;
		}
		if ( $res && $this->sort_flag ) {
			$this->prefetch_off();
			$this->CI->cms_btnsort->reset($this->get_template_filepart(), $unitid, $this->sort_type, 'unitid');
			if ( $this->sort_read_only ) {
				$this->CI->cms_btnsort->read_only();
			}
			if ( !$this->CI->cms_btnsort->init($res) ) {
				$this->prefetch_on();
				return osa_buildererror();
			}
			$this->prefetch_on();
		}
		//////////////////////////////////////////////////////////////////////////

		$pre_res = '';

		$uploads = FALSE; $selects = FALSE;
		if ( $res ) {
			$this->prefetch_off();
			if ( $this->getval('_upload_flag') !== FALSE ) {
				//Get uploads
				$uploads = $this->CI->resource_model->get_uploads($unitid,
							  		$this->getval('_typeid'), $template_file_part);
			}
			//Get selected ids for various selections
			$selects = $this->CI->resource_model->get_selections_by_restype($unitid,
								$this->getval('_typeid'), $template_file_part);
			//multi url
			$this->CI->load->model('unit/resource_model');
			//Need to pass filepart using class var because other function uses get_res_urls()
			$this->CI->resource_model->prefetch_filepart = $template_file_part;
			//Get URLs
			$res_urls = $this->CI->resource_model->get_res_urls($unitid,
								$this->getval('_typeid'));
			$this->prefetch_on();
			$this->CI->resource_model->prefetch_filepart = FALSE;

			//TODO: This has to go
			//get course name for goal unit(s)
			if ($use_linkunit != FALSE) {
				$courses = array();
				foreach ($res as $record) {
					if (isset($record->groupid) && $record->groupid != FALSE && !in_array($record->groupid, $courses)){
						$courses[] = $record->groupid;
					}
				}
				//TODO: This is very inefficient
				$course_name = $this->CI->resource_model->get_coursenames_by_groupids($courses);
			}

			$count_data = count($res);
			foreach ($res as $record) {
				if ( isset($g_pdf_mode) && $g_pdf_mode === TRUE && $this->pdf_private_resource_support &&
					  $this->user->hide_unit_private_resource == CMS_DB_BOOLEAN_TRUE && $record->ispublic == CMS_DB_BOOLEAN_FALSE ) {
					//Skip private resources for PDF document if flag in user record id is set
					continue;
				}
				if (!isset($record->restype)) {
					$record->restype = $record->type; // fix for some query no restype
				}
				$cssid_res = '';
				if ($this->multitype_sort) {
					//Reset to original in case switch_data_bytype below fails
					$this->switch_2_origdata();
					//Switch to the proper resource template. This allows the unit page and pop-up share the same template
					$this->switch_data_bytype($record->restype);
				}
				//TODO: this check only works for unit but we have many that are not units
				if ( $record->ispublic == FALSE && $this->is_teacher() == FALSE ) {
					continue;
				}
				$class = $this->color_track('listitem1', 'listitem2');

				//Text
				if ( (!is_null($record->text1) && $this->getval('_text_flag') !== FALSE) || $this->getval('_allow_no_text') === TRUE ) {
					//fix line break (<p></p> from tiny mce math editor) with replace all (tag <p>)
					//fix bug from osa_process_readtext everytime insert <br />
					//$temp = htmlspecialchars_decode(osa_process_readtext($record->text1));
					$temp = $this->text_newline_bug_hack($record->text1);
					$temp = htmlspecialchars_decode($temp);
					$temp = $this->skip_paragraph($temp);
					//TODO: What is this??
					$temp = str_replace('<!--', '<!-- ', $temp);
					$temp = str_replace('-->', ' -->', $temp);

					//cssid for compare version highlight
					if (isset($params->use_cssid) && $params->use_cssid===TRUE) {
						$pre_res = 'res'.$record->restype.'_';
						$cssid_res = "cssid='{$pre_res}{$record->id}'";
					}

					/////////////////////////////////////////////////////////////////////////////////////////////////
					//TODO: This code was a hack to get link_unit to work. Should move it to an object by itself ASAP
					if ($use_linkunit != FALSE && isset($record->groupid) && $record->groupid != FALSE) {
						//check 	access_unithiddend
						//The select process only offers unhidden published units so no need to check here
						/*
						$courseid = $course_name[$record->groupid]->courseid;
						if (!$this->access_unithidden($courseid)){
							if ($course_name[$record->groupid]->c_hidden != FALSE || $course_name[$record->groupid]->u_hidden != FALSE )
								continue;
						}
                  */
						//next time to template
						$link = base_url() . 'unit/unit/read_bygroupid/' . $record->groupid;
						//TODO: take out the call below:
						//$temp = $this->render_link_title($data, $course_name, $record->groupid, $link);
						$temp = $this->render_link_title($course_name, $record->groupid, $link);

					}
					/////////////////////////////////////////////////////////////////////////////////////////////////
					$this->html .= "<table class=\"{$class}\" border=0><tr>";
					$this->html .= "<td class=\"itemtext\" $cssid_res>" . $temp;
					if ( ($cattext = $this->getval('_category_bodytext')) !== FALSE ) {
						$this->html .= "<span style=\"margin-left:15px\">&nbsp;</span>";
						if ( ($catcolor = $this->getval('_category_color')) !== FALSE ) {
							$this->html .= "<nobr><font color=\"{$catcolor}\">{$cattext}</font></nobr>";
						}
						else {
							$this->html .= "<nobr>{$cattext}</nobr>";
						}
					}

					if ($record->ispublic == FALSE) {
						$this->html .= '<span class="privaterestext">(' . lang('unit_privateresource') . ')</span>';
					}
					$space = '<br />';

					//The selections
					$this->get_selects($record, $selects);

					//Upload
					if ( $this->getval('_upload_flag') !== FALSE && $uploads !== FALSE &&
						  array_key_exists($record->id, $uploads) ) {
						$res_uploads = $uploads[$record->id];

						foreach ($res_uploads as $file) {
							$cssid_res = '';
							if (isset($params->use_cssid) && $params->use_cssid===TRUE) {
								$pre_res = 'resup'.$record->restype.'_';
								$cssid_res = "cssid='{$pre_res}{$file->id}'";
							}
							$this->html .= '<div class="uploaditem" '.$cssid_res.'>' . lang('unit_uploadedfile') . ': ';
							/* $href= base_url() . "unit/resource/file/{$this->params->courseid}/{$this->params->unitid}/" .
									 $this->getval('_typeid') . "/" . $file->filename; */
							//$href= base_url() . "unit/resource/file/{$file->id}/{$file->filename}";
							//We URL encode the filename so browser can use non-English filenames, and prevent
							//HTTP filter to stop the request
							$tmpfile = str_replace('+',CMS_PLUS_HACK_STR,$file->filename);
							//$href= base_url() . "unit/resource/file/{$file->id}/" . urlencode($tmpfile);
							//Fix (issue: 85)
							if ( isset($g_pdf_mode) && $g_pdf_mode === TRUE ) {
								$this->html .= $file->filename;
							}
							else {
								$href= base_url() . "unit/resource/file/{$file->id}/" . osa_filename_hash($file->filename) . "/" . urlencode($tmpfile);
								$this->html .= "<a onclick=\"return downloadWindow('{$href}')\" target=\"_blank\" href=\"" . $href . '">' .
													$file->filename. '</a><span class="uploadsize">' . ' (' . osa_filesizestr($file->size) . ')';
							}
							$this->html .= '</span></div>';
						}
					}
					//URL
					//multi url
					if (isset($res_urls) && $res_urls != FALSE){
						if ( isset($res_urls[$record->id]) ){
							$urls = $res_urls[$record->id];
							$class= 'urlitem';
							//$first_step = TRUE;
							foreach ($urls as $value ){
								//$class = '';
								//if ($first_step){
								//	$first_step = FALSE;
								//}
								if ( !is_null($value->url) && $this->getval('_url_flag') !== FALSE ) {
									//cssid for compare version highlight
									if (isset($params->use_cssid) && $params->use_cssid===TRUE) {
										$pre_res = 'resurl'.$record->restype.'_';
										$cssid_res = "cssid='{$pre_res}{$value->id}'";
									}
									$this->html .= '<div class="'.$class.'" '.$cssid_res.'>' . lang('unit_uploadedurl') . ': ';
									$http_slash = 'http://';
									$colon_pos = strpos($value->url, '://');
									if ( $colon_pos > 2 && $colon_pos < 7 ) {
										//This can be http:// file:// https:// ftp://. Max is 6 (mailto) and min is 3 (ftp)
										$http_slash = '';
									}
									if ( isset($g_pdf_mode) && $g_pdf_mode === TRUE ) {
										//PDF reader lets you click anyway...
										$this->html .= $http_slash . $value->url;
									}
									else {
										$this->html .= '<a target="_blank" href="' . $http_slash. $value->url . '">' .
															 $http_slash . $value->url . '</a>';
									}
									$this->html .= '</div>';
								}
							}
						}
					}

					if ( $this->getval('_date_flag') !== FALSE && $this->getval('_date_title') !== FALSE && !is_null($record->date1)  ) {
						$this->html .= '<div class="dateitem" '.$cssid_res.'>' ;
						if (!is_array($this->getval('_date_title'))) {
							 $this->html .= $this->getval('_date_title');
						}
						$this->html .= '&nbsp;<span>'. osa_date_format( $record->date1 ). '</spam></div>';
					}
					$this->html .= $this->show_creator($record);
					$this->html .= '</td>';
				}//Text

				/////////////////////////////////////////////////////////////////
				//Sort buttons, moved into the add/delete buttons section
				/*
				if ($this->sort_flag && $count_data > 1) {
					//Sort buttons will use the unitid from $record which is the groupid for static resources
					//This ensures we always keep the same coreid for btnsort.
					$this->html .= $this->render_sort_buttons($record, $record->type);
					//Switch the unitid back to actual DB value
					//$tmpparams->unitid = $unitid;
				} */
				//Edit and delete buttons
				if ( is_array($buttons = $this->getval('_button')) ) {
					//Flag _non_editor_restrict_mode is only supported for unit template
					$restrict_mode = $this->getval('_non_editor_restrict_mode');
					if ( $restrict_mode ) {
						if ( !isset($is_course_editor) ) {
							//This really gets set only once during the loop
							//$iseditor is set only if restric mode so becareful where to use it.
							$is_course_editor = osa_is_course_editor($this->courseid());
						}
						$isowner = ($record->creatorid == $this->user->id || $record->modifierid == $this->user->id);
					}
					if ( !$restrict_mode || $is_course_editor || $isowner) {
						//$this->html .= '<td valign="middle" align="right" class="itembuttons">';
						$tmpparams = $this->params;
						$tmpparams->resid = $record->id; //assign the resource id
						//TODO: Take out this linkunit crap.
						if ($use_linkunit != FALSE && isset($record->groupid) && $record->groupid != FALSE) {
							 	if ( is_array($buttons = $this->getval('_button_linkunit')) ) {
							 			$tmpparams->resid = $record->groupid;
							 	}
						}
						//We want the edit and delete buttons to use the original/current unitid for static resource.
						//The add/update/delete routines in resource.php will get the static unitid base don the original/current unitid.
						//Always do this even for non-static which will not affect anything
						$tmp_unitid = $tmpparams->unitid;
						$tmpparams->unitid = $orig_unitid;
						//$this->html .= $this->buttonsobj->render($buttons, $tmpparams);
						$tmp_html = $this->buttonsobj->render($buttons, $tmpparams);
						//Switch back the unitid in params else sort buttons will break.
						//Sorting needs to use the old static unitid
						$tmpparams->unitid = $tmp_unitid;
						if ( !$restrict_mode || $is_course_editor ) {
							//This will not run if in restrict mode and user is not course editor even when user has edit permission
							if ( $tmp_html && $this->sort_flag && $count_data > 1) {
								//Put sort buttons here so if no edit and delete then there would be no sort too
								//Sort buttons will use the unitid from $record which is the groupid for static resources
								//This ensures we always keep the same coreid for btnsort.
								$this->html .= $this->render_sort_buttons($record, $record->type);
							}
						}
						$this->html .= '<td valign="middle" align="right" class="itembuttons">' . $tmp_html . '</td>';
						//$this->html .= '</td>';
					}
				} //Buttons
				/////////////////////////////////////////////////////////////////

				$this->html .= "</tr></table>";
			} //foreach resource
		}
		if ( $this->multitype_sort ) {
			$this->switch_2_origdata();
		}
		return $this->html;
	}
/*
	function butonedit_bytype($record, $buttons, $tmpparams) {
		$html = '';
		$new_button = array();
		foreach ($buttons as $btn) {
			if (isset($btn['_is_editbutton'])==FALSE)
				$new_button[] = $btn; // delete button and other button
			else {
				if ( $btn['_is_editbutton']==TRUE && $record->restype == $btn['_type'])
					$new_button[] = $btn;	// edit button only type = restype(from resource table)
			}
		}

		$html = $this->buttonsobj->render($new_button, $tmpparams);
		return $html;
	}
*/

	//$params contains extra member 'type'/resource-type
	function popup_data($typedata=FALSE, $params=FALSE) {
		if ( $typedata !== FALSE && $params !== FALSE )
			$this->reset($typedata, $params);
		$data = new stdClass;
		$data->unitid = $this->params->unitid;
		$data->divid = $this->params->divid;
		$data->action = $this->params->action;
		$data->stagenum = $this->params->stagenum;
		//$data->resid =
		//if ( ($data->text_flag = $this->getval('_text_flag')) === TRUE ) {
			//$this->assign_obj_values($data, array('_text_title','_text_cols','_text_rows'));
		//}
		//$this->assign_obj_values($data, array('_save_text','_cancel_text','_delete_text'));
		$this->copy_values($data);
		if ( $this->params->action == CMS_ACTION_ADD ) {
			$data->title = $this->getval('_title_add');
			$data->_delete_text = FALSE; //Make sure we don't show the delete button if add action
		}
		elseif ($this->params->action == CMS_ACTION_EDIT) {
			$data->title = $this->getval('_title_edit');
		}
		return $data;
	}

	private function get_selects($record, $selects, $tmplate_sep=': ') {
		$html = '';
		$track = 0;
		$template_var = 'select';
		$pre_ressel = 'ressel_';
		$cssid_ressel = '';

		$select_order = $this->getval('_select_order');
		if ( !is_array($select_order) ) {
			//This is done to support template without _select_order
			$select_order = array();
			for ($i=1; $i<=$this->max_selects; $i++) {
				$select_order[] = $i;
			}
		}

		//for ( $i=1; $i<=$this->max_selects; $i++ ) {
		foreach($select_order as $i) {
			$dbfield = $template_var . $i;
			$selflag = '_' . $template_var . '_flag' . $i;
			$selarray = '_' . $template_var . $i;
			$seltitle = '_' . $template_var . '_title' . $i;
			$selectcolor = '_' . $template_var . '_color' . $i;

			$ischeckbox = $this->getval('_' . $template_var . '_checkbox_type' . $i);
			$cur_tmplate_sep = $tmplate_sep;
			if ( $ischeckbox )
				$cur_tmplate_sep = '';
			$index = $record->id . '_' . $i;
			if ( is_array($selects) && array_key_exists($index, $selects) && is_array($selects[$index]) && count($selects[$index])>0 ) {
				if ( $this->getval($selflag) !== FALSE ) {
					$multi_selects = $selects[$index];
					foreach($multi_selects as $select) {
						if ( !$ischeckbox ) {
							$options = $this->getval($selarray);
							if ( $options === FALSE || !is_array($options) ) {
								$this->error(__METHOD__ . ' - Empty options in template', $record);
								continue;
							}
							if ( !array_key_exists($select, $options) ) {
								$this->error(__METHOD__ . " - Can not find option for resid:{$record->id} " .
												"type:{$record->restype} {$dbfield}:{$select}", $record);
								continue;
							}
						}
						else {
							//Fake the options for checkboxes
							$options = array(1=>'');
						}

						if ( $track > 0 ) $html .=  "<br/>";
						$track++;
						$tmphtml = $this->getval($seltitle) . $cur_tmplate_sep;
						$tmphtml .= $options[$select];


						//cssid for compare version highlight
						if (isset($this->params->use_cssid) && $this->params->use_cssid===TRUE) {
							$cssid_ressel = "cssid='{$pre_ressel}{$index}_{$select}'";
						}
						if ( ($color = $this->getval($selectcolor)) !== FALSE ) {
							$html .= "<font color=\"$color\" $cssid_ressel>$tmphtml</font>";
						}
						else {
							$html .= $tmphtml;
						}
					}//for
				} //if select
			} // if array_key_exists
		} //for
		if ( $html != '') {
			$this->html .= "<div class=\"selectitem\">{$html}</div>";
		}
	}

	//TODO: Have to check this code to make sure no perfromance impact
	//Looks like stripping out <p> tags to prevent extra empty lines on the unit page.
	private function skip_paragraph(&$temp){
		if ( !$temp ) {
			return $temp;
		}
		$p_tag = explode("</p>", $temp);
		$newtemp = '';
		$ptag_total = count($p_tag);
		if (is_array($p_tag) && $ptag_total>=2) {
			$i = 0;
			$last_p = '';
			foreach ($p_tag as $line) {
				if ($i == 0) {
					$newtemp = str_replace("<p>",'', $line);
				}
				elseif ( $i == ($ptag_total-2) ) {
					$newtemp .= str_replace("<p>",$last_p, $line);
				}
				else {
					if (strpos($line , '<p>')) {
						$last_p = '</p>';
					}
					$newtemp .= $line;
				}
				$i++;
			}
		}
		else {
			//$newtemp = $temp;
			return $temp;
		}
		return $newtemp;
	}

	private function switch_data_bytype($restype) {
		if ( !is_numeric($restype) )
			return;
		//This contains multiple type data
		$multi_data = $this->getval('_sort_multitype_data');
		if ( !is_array($multi_data) )
			return;
		if ( !array_key_exists($restype, $multi_data) )
			return;
		$this->data = &$multi_data[$restype];
	}

	private function switch_2_origdata() {
		//if ( $this->orig_data != NULL )
		$this->data = &$this->orig_data;
	}

	//Show the creator and modifier names
	private function show_creator(&$resource) {
		if ( !is_object($resource) ) {
			return '';
		}
		$html = '';
		$show_creator = $this->getval('_show_creator');
		$show_modifier = $this->getval('_show_modifier');
		$creatorname = '';
		if ( isset($resource->creatorid) && !empty($resource->creatorid) && (($show_creator === TRUE) ||
			  ($show_creator && ($show_creator == $this->params->action || $this->params->action == CMS_ACTION_ALL))) ) {
			//the logic is the flag can be TRUE and will show always, or the flag is an action - edit or read
			$creatorname = osa_user_getname_byid($resource->creatorid);
			$html = '<nobr>' . lang('unit_resource_creator_title') . "{$creatorname}</nobr>";
		}
		if ( isset($resource->modifierid) && !empty($resource->modifierid) && (($show_modifier === TRUE) ||
			  ($show_modifier && ($show_modifier == $this->params->action || $this->params->action == CMS_ACTION_ALL))) ) {
			//the logic is the flag can be TRUE and will show always, or the flag is an action - edit or read
			if ( ($resource->modifierid == $resource->creatorid) && $creatorname != '' ) {
				$modifiername = $creatorname;
			}
			else {
				$modifiername = osa_user_getname_byid($resource->modifierid);
			}
			if ( $html != '' ) {
				$html .= ' &nbsp;&nbsp; ';
			}
			$html .= '<nobr>' . lang('unit_resource_modifier_title') . "$modifiername</nobr>";
		}
		if ( $html == '' ) {
			return '';
		}
		return "<div class='unit_res_creator'>$html</div>";
	}

	private function prefetch_on() {
		if ( $this->static_res ) {
			$this->CI->cms_prefetch->set_enable();
		}
	}

	private function prefetch_off() {
		if ( $this->static_res ) {
			$this->CI->cms_prefetch->disable();
		}
	}

	//Firefox always adds this new line after every edit. So don't show it.
	private function text_newline_bug_hack(&$text) {
		if ( !$text ) {
			return '';
		}
		$bad_text = '&lt;br /&gt;';
		$bad_text_len = 12;
		$text_len = strlen($text);
		if ( $text_len <= ($bad_text_len+1) ) {
			return $text;
		}
		$last12 = strtolower(substr($text, $text_len-$bad_text_len, $text_len-1));
		if ( $last12 == $bad_text ) {
			return substr($text, 0, $text_len-$bad_text_len);
		}
		return $text;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	//TODO: This function does the linkunit stuff, should go away ASAP
	//private function render_link_title($template, $itemdata , $itemid, $link=FALSE, $onClick=FALSE){
	private function render_link_title($itemdata , $itemid, $link=FALSE, $onClick=FALSE){
		$html = '';
		if (!is_numeric($itemid) || $itemdata == FALSE || !isset($itemdata[$itemid]))
			 return $html;

		//check 	course and unit hiddend
		$hidden = '';
		$class_unit = 'cmslink';
		$class_course = 'linkunit';
		if ($itemdata[$itemid]->c_hidden != FALSE || $itemdata[$itemid]->u_hidden != FALSE ){
			$hidden = '(' . lang('unit_unithidden') . ')';
			$class_unit = 'linkunitlink';
			$class_course = 'linkunit_hide';
		}
		// hard code field name
		$front = $itemdata[$itemid]->unittitle;
		$back = $itemdata[$itemid]->name;

		$title = lang('unit_copy_col_unit');
		$onClick = "newDhtmlWindow('{$link}','{$title}',900,800,'unitread'); return false; ";
		//if ($onClick == FALSE)


		if ($link == FALSE)
			 $link = "{$front}";
		else
			 $link = "<a class=\"$class_unit\" href=\"$link\" onclick=\"{$onClick}\" >{$front}</a>";

		$linktitle = $this->getval('_link_title'); //$template['_link_title'];
		if ( empty($linktitle) ) {
			osa_load_lang('linkunit');
			$linktitle = lang('linkunit_title');
		}
		$html .= $linktitle . ' ';
		$html .= $link;
		$html .= '&nbsp;<span class='.$class_course.' >('.$back.')</span>';
		$html .= '<span class="privaterestext">' . $hidden . '</span>';
		return $html;
	}
	////////////////////////////////////////////////////////////////////////////////////////////////////

//Use check access unithidden
/*
	private function access_unithidden($courseid){
		if (!is_numeric($courseid))
			return FALSE;
		$user = FALSE;
		$this->CI->load->model('auth/login_model');
		$this->CI->load->model('unit/resource_model');
		if ( ($user = $this->CI->login_model->getLogin()) !== FALSE ){
			$isAdminUnitWrite = $this->CI->access_model->checkaccess_any('admin_unit_write',$user,FALSE,FALSE);
			//Get the courses for this user
			$ismycourse = $this->CI->resource_model->is_teacher($user->id, $courseid);
			if ( $ismycourse || $isAdminUnitWrite )
				return TRUE;
		}
		return FALSE;
	}
*/
}
?>