<?php
/**
 * unit_lt.php - Handles the rendering of Learning Target data
 *
 * @author $Author: dtong $
 * @version $Id: unit_lt.php,v 1.27 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_lt extends unit_base {

	function __construct() {
		parent::__construct();
		$this->CI->load->model('unit/lt_model');
	}

	function render($data, $params) {
		$pre_str = 'ltstr';
		$pre_sta = 'ltsta';
		$pre_ben = 'ltben';
		$cssid_str = '';
		$cssid_sta = '';
		$cssid_ben = '';
		$use_cssid = FALSE;

		if ( $data !== FALSE && $params !== FALSE )
			$this->reset($data, $params);
		$this->html = '<div class="sb_body">';
		$dbobjs = $this->CI->lt_model->get_strand_tree($this->unitid(), $this->type());

		//Create the array structure from db records
		$db_struct = array();
		if ( $dbobjs ) {
			$last_strandid='';
			$last_standardid='';
			//Build the array structure for display purpose
			foreach($dbobjs as $record) {
				if ( $last_strandid != $record->strandid) {
					$db_struct[$record->strandid][0] = $record->strand;
					$last_strandid = $record->strandid;
				}
				if ($last_standardid != $record->standardid) {
					//$benchmark[$record->standardid][0][0] = $record->benchmarkid;
					$db_struct[$record->strandid][$record->standardid][0] = $record->standard;
					$last_standardid = $record->standardid;
				}
				$db_struct[$record->strandid][$record->standardid][] = $record;
			}
		}

		//cssid for compare version highlight
		if (isset($params->use_cssid) && $params->use_cssid===TRUE)
			$use_cssid = TRUE;

		//Loop thru the arrays for html output
		foreach ($db_struct as $strandid => $strand) {
		 	if ($use_cssid)
		 		 $cssid_str = "cssid='{$pre_str}{$this->type()}_{$strandid}'";

			$this->html .= "<div class=\"sb_strand\" $cssid_str>" . $this->getval('_strand_title') . ": {$strand[0]}";
			foreach ($strand as $standardid => $standard) {
				if ( $standardid == 0 ) continue;
				if ($use_cssid)
				    $cssid_sta = "cssid='{$pre_sta}{$this->type()}_{$standardid}'";

				$this->html .= "<div class=\"sb_std\" $cssid_sta>" . $this->getval('_standard_title') . ": {$standard[0]}</div>";
				$this->color_track_reset();

				if (!$this->CI->config->item('cms_hide_benchmarks')) {
					$this->html .= "<div class=\"sb_benchtitle\">" . $this->getval('_bench_title') . ":</div>";

					foreach ($standard as $index => $benchmark) {
						if ( $index == 0 ) continue;
						if ($use_cssid) {
							 $cssid_ben = "cssid='{$pre_ben}{$this->type()}_{$benchmark->id}'";
							 $class = 'sb_bench2';
						}
						else
							 $class = $this->color_track('sb_bench1','sb_bench2');
						$this->html .= "<div class=\"{$class}\" $cssid_ben>{$benchmark->data}</div>";
					}
				}
			}
			$this->html .= "</div>";
		}
		$this->html .= "</div>";
		return $this->html;
	}

	/*
	 * Prints the learning targets on the body page
	 */
	function render_lt($data, $params) {
		if ( $data !== FALSE && $params !== FALSE )
			$this->reset($data, $params);
		$this->CI->load->library('cms/cms_btnsort');

		$pre_tar = CMS_MODULE_LEARNING_TARGETS;
		$cssid_tar = '';
		$use_cssid = FALSE;
		$this->html = '';
		$this->CI->lt_model->sort_read_only = $this->sort_read_only;
		$this->CI->lt_model->sort_type = $this->sort_type;
		$this->CI->lt_model->sort_filehash = $this->get_template_filepart();
	 	$dbobjs = $this->CI->lt_model->get_targets($this->unitid(), $this->type());
	 	if ( $dbobjs === NULL ) {
	 		return osa_buildererror();
	 	}
		if ( $dbobjs ) {
			$lastdeptid = '';
			$this->html = '<div class="lt_body">';
			$this->color_track_reset();
			$select_array = $this->getval('_select1');
			$depts = $this->CI->lt_model->get_departments_bycourse('id', TRUE);
			$check_buttonid = '';
			$check_firstid  = '';
			$check_lastid   = '';
			$count_data = count($dbobjs);
			if ($count_data > 1) {
		 		$check_firstid  = $dbobjs[0]->id;
				$check_lastid   = $dbobjs[$count_data-1]->id;
			}
			//cssid for compare version highlight
			if (isset($params->use_cssid) && $params->use_cssid===TRUE) {
				 $use_cssid = TRUE;
				}
			$dept_rowcount = 0;
			foreach ($dbobjs as $key => $record) {
				$dept_rowcount++;
				//Department names were always in the existing query result. Old programmer was so crazy to put
				//department query calls in a loop! Already put query cache in the 2 calls below but only to found out
				//they are totally unnecessary.
				//$show_dept = $this->CI->unit_model->get_department_display($record->courseid);
				$show_dept = $record->department_display;
				if (!$show_dept) {
					//$show_dept = $this->CI->select_model->get_department($depts ,$record->courseid );
					$show_dept = $record->departmentname;
				}
				$use_buttons_last = FALSE;
				if ( $check_lastid && $check_lastid != $record->id ) {
					if ( $dbobjs[$key+1]->departmentid != $record->departmentid ) {
						//Next record has different dept so use buttons lat
						$use_buttons_last = TRUE;
					}
				}
				$use_buttons_first = FALSE;
				$use_no_buttons = FALSE;
				if ($lastdeptid == '' || $lastdeptid != $record->departmentid) {
					$dept_rowcount = 1;
					//Dept in previous rows is different so use buttons first
					$use_buttons_first = TRUE;
					if ( $count_data>1 && (($check_lastid==$record->id && $key+1 == $count_data) ||
							$dbobjs[$key+1]->departmentid != $record->departmentid) ) {
						//First row in dept but next row will have different dept so no button.
						//This will override all the button flags
						$use_no_buttons = TRUE;
					}
					if ( $lastdeptid !== '' ) {
						$this->html.= "<div style='font-style:italic;margin-top:10px'>$show_dept</div>";
					}
					else {
						if ( $this->action() == CMS_ACTION_EDIT ) {
							$this->html.= "<div style='font-style:italic;margin-top:-3px'>$show_dept</div>";
						}
						else {
							$this->html.= "<div style='font-style:italic'>$show_dept</div>";
						}
					}
				   $lastdeptid = $record->departmentid;
				}
				if ($use_cssid) {
					$cssid_tar = "cssid='{$pre_tar}_{$record->id}'";
					$color = 'lt_item2';
				}
				else
					$color = $this->color_track('lt_item1', 'lt_item2');

				$this->html .= "<div class=\"$color\" $cssid_tar><table width=\"100%\" style=\"margin:0px\"><tr><td>";
				$data_target = $record->data;
					if ($params->courseid!=$record->courseid)
						$data_target = $data_target.' '.'<span class="course_lnk_link_title">'.'('.$record->coursename.')'.'</span>';
				$this->html .= "{$data_target}";
				// render discription (LT,S&S,SSK)
				if ( ($cattext = $this->getval('_category_bodytext')) !== FALSE ) {
					$this->html .= "<span style=\"margin-left:15px\">&nbsp;</span>";
					if ( ($catcolor = $this->getval('_category_color')) !== FALSE ) {
						$this->html .= "<nobr><font color=\"{$catcolor}\">{$cattext}</font></nobr>";
					}
					else {
						$this->html .= "<nobr>{$cattext}</nobr>";
					}
				}
				$this->html .= "</td>";
				//$this->html .= '<td class="lt_symbol">';
				$this->html .= '<td width="85" valign="middle" align="right" class="itembuttons"><nobr>';
				$this->html .= '<span class="lt_symbol">';
				if ( !is_null($record->select1) && $select_array !== FALSE && array_key_exists($record->select1, $select_array)) {
					$this->html .= $select_array[$record->select1];
				}
				//$this->html.= '</td>';
				$this->html.= '</span>';
				//Buttons
				if ( is_array($buttons = $this->getval('_button')) ) {
					//$this->html .= "<td class=\"itembuttons\">111</td>";
					//$this->html .= '<td width="60" valign="middle" align="right" class="itembuttons"><nobr>';
					$this->html .= '<span class="itembuttons">';
					$tmpparams = $this->params;
					$tmpparams->resid = $record->id; //assign the resource id

					if ($count_data > 1 && !$use_no_buttons ) {
						$check_buttonid = $record->id;
						if ( $check_buttonid == $check_firstid || $use_buttons_first ) {
							$this->html .= $this->buttonsobj->render(
													$this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_FIRST,
													$record,$this->sort_type), $tmpparams);
						}
						elseif ( $check_buttonid == $check_lastid || $use_buttons_last ) {
							$this->html .= $this->buttonsobj->render(
													$this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_LAST,
													$record,$this->sort_type), $tmpparams);
						}
						else {
							$this->html .= $this->buttonsobj->render(
													$this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_MIDDLE,
													$record,$this->sort_type), $tmpparams);
						}
					}
					//Render the delete and edit buttons
					$this->html .= $this->buttonsobj->render($buttons, $tmpparams);

					$this->html .= '</span></nobr></td>';
				}//Buttons
				else {
					$this->html .= '<td class="itembuttons"></td>';
				}
				$this->html .= '</tr></table></div>';
			}
			$this->html .= '</div>';
		}
		return $this->html;
	}
}
?>