<?php
/**
 * unit_last.php - Handles the rendering of user selections from the selection pages like EQ
 *
 * @author $Author: dtong $
 * @version $Id: unit_last.php,v 1.8 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_last extends unit_base {

	function __construct() {
		parent::__construct();
	}

	function render($data, $params) {
		$pre_last = CMS_CSS_ZMS_SUBJECTAREA . CMS_SUBJECTAREA_LEARNING_ST . '_';
		$cssid_last = '';
		$use_cssid = FALSE;

		if ( $data !== FALSE && $params !== FALSE )
			$this->reset($data, $params);
		$this->html = '';
		$this->CI->load->model('unit/last_model');
		$selects = $this->CI->last_model->get_category($this->params->unitid, $this->getval('_typeid'));

		// get all departments & toArray with id is key
		$depts = $this->CI->select_model->get_departments('id',TRUE);

		//cssid for compare version highlight
		if (isset($params->use_cssid) && $params->use_cssid===TRUE)
			$use_cssid = TRUE;

		$first_course = TRUE;
		if ( $selects ) {
			$lastdeptid = '';
			foreach($selects as $select) {
				if ($use_cssid)
					 $cssid_last = "cssid='{$pre_last}{$select->catid}'";

				$class = $this->color_track('listitem1', 'listitem2');

				// get department name from department id and return with <div><i> tag html(default)
				$show_dept = $this->CI->last_model->get_department($depts ,$select->departmentid );

				$this->html .= "<table class=\"$class\" cellspacing='0' cellpadding='0' border='0'>";
				if ($lastdeptid =='' || $lastdeptid != $select->departmentid) {
					$margin = '';
					if ( !$first_course )
						$margin = "style='margin-top:5px;'";
					$lastdeptid = $select->departmentid;
					//$this->html.= $show_dept;
					$this->html.= "<tr><td class=\"itemtext_italic\" colspan='2'><div $margin >".$show_dept."</div></td></tr>";
					$first_course = FALSE;
				}

				$this->html .= "<tr><td class=\"itemtext\" {$cssid_last}>";
				$this->html .= "{$select->text}";
				if ( ($cattext = $this->getval('_category_bodytext')) !== FALSE ) {
						$this->html .= "<span style=\"margin-left:15px\">&nbsp;</span>";
						if ( ($catcolor = $this->getval('_category_color')) !== FALSE ) {
							$this->html .= "<nobr><font color=\"{$catcolor}\">{$cattext}</font></nobr>";
						}
						else {
							$this->html .= "<nobr>{$cattext}</nobr>";
						}
					}
				$this->html .="</td>";

				//Buttons
				if ( is_array($buttons = $this->getval('_button')) ) {
					//$this->html .= "<td class=\"itembuttons\">111</td>";
					$this->html .= '<td valign="middle" align="right" class="itembuttons">';
					$tmpparams = $this->params;
					$tmpparams->resid = $select->id; //assign the resource id
					$this->html .= $this->buttonsobj->render($buttons, $tmpparams);
					$this->html .= '</td>';
				}//Buttons
				$this->html .="</tr></table>";
			}
			//$this->html .= '</div>';
		}
		return $this->html;
	}

}
?>