<?php
/**
 * unit_init.php
 *
 * Initial unit object
 *
 * TODO: Should this class be here?
 *
 * @author $Author: dtong $
 * @version $Id: unit_init.php,v 1.3 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class unit_init {
	function __construct() {
		$this->CI = & get_instance();
		$this->CI->load->model('unit/unit_model');
		//$this->CI->load->model('sort/sort_model');
	}

	public function get_viewdata($unitid, $all_flag=FALSE) {
		if (is_object($unitid)) {
			$unit = $unitid;
			$unitid = $unit->id;
		}
		else {
			if ($all_flag===FALSE)
				$unit = $this->CI->unit_model->get_unit($unitid);
			else
				$unit = $this->CI->unit_model->get_unit_any($unitid);
		}
		if ( !$unit ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}
		$course = $this->CI->unit_model->get_course($unitid);
      	if ( !$course ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}

        $data->coursename = $course->name;
        $data->unit = $unit;
 		$this->_get_unittype_lang($unit, $data, $course);

	   	return $data;
	}

	private function _get_unittype_lang($unit, $data, $course, $courseid=FALSE) {
		$type   = $unit->type;
		$status = $unit->status;
		$data->displaytype = TRUE;	// normal:not display , another type: display
		$data->iscreator   = FALSE;
		$data->integrated_flag = FALSE;
		$data->unified_flag    = FALSE;
		$unit_lang ='';

		$data->meta_flag = FALSE;
		$data->change_flag = TRUE;
		$data->distribute  = FALSE;
		switch ($type) {
			case $this->CI->unit_model->TYPE_NORMAL:
				$unit_lang = lang('unit_normal');
				break;
			case $this->CI->unit_model->TYPE_META:
				$unit_lang = lang('unit_metaunit');
				break;
			case $this->CI->unit_model->TYPE_INT_PARENT:
				$data->integrated_flag = TRUE;
				$unit_lang = lang('unit_integratedunit');
				$data->distribute = $this->CI->unit_model->status_distribute($unit);
				break;
			case $this->CI->unit_model->TYPE_INT:
				$data->integrated_flag = TRUE;
				$unit_lang = lang('unit_integratedunit');
				break;
			case $this->CI->unit_model->TYPE_UNI_PARENT:
				$data->unified_flag = TRUE;
				$unit_lang = lang('unit_unifiedunit');
				$data->distribute = $this->CI->unit_model->status_distribute($unit);
				break;
			case $this->CI->unit_model->TYPE_UNI:
				$data->unified_flag = TRUE;
				$unit_lang = lang('unit_unifiedunit');
				break;
      	}


      	$data->unittypename= $unit_lang;
      	$data->meta_flag   = $this->_get_unittype_meta($type);

		//if ( ($type == $this->CI->unit_model->TYPE_INT_PARENT ) || ($type == $this->unit_model->TYPE_UNI_PARENT) ) {
	//	if ( $type != $this->unit_model->TYPE_NORMAL ) {
	//	      $data->displaytype = TRUE;
	//		}


      	if ($courseid != FALSE) {
			$action = CMS_ACTION_EDIT;
		    if ($courseid != $course->id ) {
		        if ($data->unified_flag==TRUE) {
		            $action = CMS_ACTION_READ;
		        } else {
		        	$action = CMS_ACTION_EDIT;
		        }
		    } else {
		        	$data->iscreator = TRUE;
		    }

	        $this->load->library('unit/Unitmain',
			array('action'=>$action, 'unitid'=>$unit->id, 'courseid'=>$unit->courseid));
			$data->unitbody = $this->unitmain->render($data->meta_flag);
      	}
	}

	private function _get_unittype_meta($type) {
      	$result = FALSE;
		if  ($type == $this->CI->unit_model->TYPE_META)
			$result = TRUE;
		return $result;
	}
}
?>