<?php
/**
 * unit_buttons.php - render the buttons data
 *
 * @author $Author: dtong $
 * @version $Id: unit_buttons.php,v 1.31 2011/05/13 05:12:58 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_buttons extends unit_base {

	function __construct() {
		//parent unit_base uses this object so don't call parent constructor
		//parent::__construct();
		$this->CI = & get_instance();
	}

	//Returns the button(s) html
	function render($buttons, $params) {
		global $g_pdf_mode;

		if ( !$buttons ) {
			//This is necessary since btnsort can return FALSE for readonly operation.
			return '';
		}
		$this->reset($buttons, $params);
		$this->CI->load->library('unit/event/event_handle_main');
		//See if we need to skip the buttons for pdf and unit compare
		if ( (isset($g_pdf_mode) && $g_pdf_mode === TRUE) || $params->use_cssid) {
			//template tells which button to skip for pdf
			//if ( $this->getval('_skip4pdf',$button) === TRUE )
			//Just skip all buttons for PDF and stop using _skip4pdf
			return;
		}
		foreach ($buttons as $button) {
			//Check read,write access for each template object
			//The buttons are different, they have to be checked inside unit_buttons.php
			//If there is no access for a object then it will continue/skip to the next one even before the switch below
			if ( !$this->CI->event_handle_main->run($button, $params) ) {
				$this->html .= $this->CI->event_handle_main->html_error_msg;
				continue;
			}
			//Assign error msg from event_handle_main if any. This is empty string if no error occured.
			$this->html .= $this->CI->event_handle_main->html_error_msg;

			if ( !osa_valid_action($this->getval('_action',$button), $this->params->action)) {
					if ( !(osa_valid_action($this->getval('_action',$button), CMS_ACTION_MY) && $this->is_teacher()) )
					continue;
			}

			if ( ($type = $this->getval('_type',$button)) === FALSE ) {
				$this->error(__METHOD__ . ' - Missing Type', $button);
			}

			if ( $this->getval('_empty_button', $button) === TRUE ) {
				$this->print_empty_button();
				continue;
			}

			if ( ($link = $this->getval('_link',$button)) === FALSE) {
				$this->error(__METHOD__ . ' - Missing Type', $button);
			}
			/* Don't need title, some old templates are still using this...
			$title = $this->getval('_title',$button);
			if ( !$title )
				$title = '';
			else
				$title = ' ' . $title;
			*/
			$image = $this->getval('_image',$button);
			if ( $image ) {
				if ( ($alt_title = $this->getval('_alt_title', $button)) !== FALSE )
					$alt_title = "title=\"$alt_title\"";
				else
					$alt_title = "";

				$image_id = "";
				if ( ($image_id = $this->getval('_image_id', $button)) !== FALSE )
					$image_id = "id=\"$image_id\"";

				$image = "<img {$image_id} {$alt_title} src=\"" . osa_imagepath() . $image . '" border="0" />';
			}
			else {
				$image='';
			}

			if ( empty($image) ) {
				$this->error(__METHOD__ . ' - Missing image and title', $button);
				$this->html .= osa_buildererror();
				continue;
			}

			//Replace unitid and resid in the links and jscript from the template
			$link = str_replace(parent::UNITID_PATTERN, $this->params->unitid, $link);
			if ( property_exists($this->params, 'resid' ) && is_numeric($this->params->resid) )
				$link = str_replace(parent::RESID_PATTERN, $this->params->resid, $link);
			$link = str_replace(parent::STAGEDIV_PATTERN, $this->params->divid, $link);
			$link = str_replace(parent::STAGENUM_PATTERN, $this->params->stagenum, $link);
			$link = str_replace(parent::COURSEID_PATTERN, $this->params->courseid, $link);

			$jscript = $jevent = '';
			if ( ($jscript = $this->getval('_jscript',$button)) !== FALSE ) {
				$jscript = str_replace(parent::UNITID_PATTERN, $this->params->unitid, $jscript);
				if ( property_exists($this->params, 'resid' ) && is_numeric($this->params->resid) ) {
					$jscript = str_replace(parent::RESID_PATTERN, $this->params->resid, $jscript);
				}
				$jscript = str_replace(parent::STAGEDIV_PATTERN, $this->params->divid, $jscript);
				$jscript = str_replace(parent::STAGENUM_PATTERN, $this->params->stagenum, $jscript);
				$jscript = str_replace(parent::COURSEID_PATTERN, $this->params->courseid, $jscript);

				if ( ($jevent = $this->getval('_jevent',$button)) !== FALSE && $jevent != '') {
					$jscript = " {$jevent}=\"{$jscript}\" ";
				}
				else {
					$jscript = " onClick=\"{$jscript}\" ";
				}
			}

			$href = '';
			if ( $link != '' && $link != FALSE ) {
				$href = "href=\"{$link}\"";
			}

 			$this->html .= "<div class=\"unitbutton\">";
 			if ( empty($jscript) ) {
 				$this->html .= "<a $href class=\"buttonalink\" >{$image}</a>";
 			}
 			else {
 				$this->html .= "<a $href class=\"buttonalink\" {$jscript}>{$image}</a>";
 			}
 			$this->html .= "</div>";
		}
		if ( !$this->html ) {
			return '';
		}
		return '<nobr>' . $this->html . '</nobr>';
	}

	private function print_empty_button() {
		$this->html .= '<div class="unitbutton"><img border="0" src="' . osa_imagepath() . 'none.gif" /></div>';
	}
}
?>