<?php
/**
 * pph_show_admin_note.php
 *
 * Stage handle to show the admin notes section or not. The flag is located in the my profile.
 * The hide_unit_private_resource for PDF also affects this.
 *
 * @author $Author: dtong $
 * @version $Id: pph_show_admin_note.php,v 1.4 2011/05/16 08:11:47 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

require_once('pph_base.php');

class pph_show_admin_note extends pph_base {
	function process(&$stage, $stagenum, $meta_flag, $params) {
		global $g_pdf_mode;

		$user = osa_login_object();
		if ( !is_object($user) || !property_exists($user, 'hide_unit_admin_note') ||
			  !property_exists($user, 'hide_unit_private_resource') ) {
			return FALSE;
		}
		if ( $user->hide_unit_admin_note == CMS_DB_BOOLEAN_TRUE ||
			 ($user->hide_unit_private_resource == CMS_DB_BOOLEAN_TRUE && isset($g_pdf_mode) && $g_pdf_mode === TRUE) ) {
			return FALSE;
		}
		return TRUE;
	}
}