<?php
/**
 * paging_creator_role
 *
 * Check the document creator/owner role(s). This means we can have different pages
 * based on the owner with the same document.
 *
 * @author $Author: dtong $
 * @version $Id: paging_creator_role.php,v 1.2 2011/04/13 10:20:09 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

require_once ('paging_base.php');

class paging_creator_role extends paging_base {

	function __construct() {
		parent::__construct();
		$this->handle_param_list = array('_roles');
	}

	function invoke() {
		$user = osa_login_object();
		if ( !$user ) {
			return FALSE;
		}
		$userroles = osa_value($this->handle_check_array, '_roles', FALSE);
		if ( !$this->valid_role_string($userroles) ) {
			osa_errorlog(__METHOD__ . " - Invalid _roles $userroles", $this->handle_check_array);
			return osa_buildererror();
		}
		$this->CI->load->model('unit/event/handle_user_role_model');
		return $this->CI->handle_user_role_model->creatorid_has_roles($this->template_identifier, $this->unitid, $userroles);
	}

	//Function to make sure the role list from the template is valid
	private function valid_role_string($roles) {
		return preg_match('/^[123456789][,1234567890]*$/', $roles);
	}
}