<?php
/**
 * handle_is_goal_editor - For any one with general goal editing rights. This includes creator, system admin,
 * 								goal admin and team members assigned with editing rights.
 *
 * @author $Author: dtong $
 * @version $Id: handle_is_goal_editor.php,v 1.3 2010/08/03 13:49:22 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

require_once('handle_base.php');

Class handle_is_goal_editor extends handle_base {
	/*
	 * Valid handle parameters:
	 * 	_check_read (boolean) - check for read action
	 * 	_check_edit (boolean) - check fore edit action
	 * 	_members_edit_right (boolean) - Goal members have edit right or not.
	 * 	_members_can_read (boolean) - Always give read access to members.
	 *
	 * These 2 parameters can co-exist on the same line in the handle array.
	 * Note, there can be only one actual action at any given time for the template.
	 */
	function invoke() {
		$goalid = $this->unitid;
		//We don't have a vlaid goal id
			if ( !is_numeric($goalid) )
				return FALSE;
			$check_read_flag = osa_value($this->handle_data, '_check_read', FALSE);
			$check_edit_flag = osa_value($this->handle_data, '_check_edit', FALSE);
			$member_read_access = osa_value($this->handle_data, '_members_can_read', FALSE);

			if ( $this->is_action_read() && $check_read_flag == FALSE )
				return TRUE;
			if ( $this->is_action_edit() && $check_edit_flag == FALSE )
				return TRUE;
			if ( $this->is_action_edit() && $member_read_access && $this->CI->goal_model->is_goal_member($goalid) ) {
				$this->change_action2read();
				return TRUE;
			}

			$include_members = osa_value($this->handle_data, '_members_edit_right', FALSE);

			//At this point we know we have to check and we don't care is it read or edit
			$this->CI->load->model('goal/goal_model');
			//ZIS does not have goal members but use it anyway. It doesn't hurt and it will work with goal members
			if ( $include_members )
				return ($this->CI->goal_model->is_edit_goal($goalid) || $this->CI->goal_model->is_goal_member($goalid));
			else
				return ($this->CI->goal_model->is_edit_goal($goalid) );
	}
}