<?php
/**
 * handle_is_goal_admin.php - Handle to check to see is the user the goal admin. Gives read access to goal creator and members.
 *
 * @author $Author: dtong $
 * @version $Id: handle_is_goal_admin.php,v 1.1 2010/08/03 13:49:22 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

require_once('handle_base.php');

Class handle_is_goal_admin extends handle_base {

	function invoke() {
		$goalid = $this->unitid;
		//We don't have a vlaid goal id
		if ( !is_numeric($goalid) )
			return FALSE;

		if ( $this->CI->access_model->checkaccess_any_noexit('admin_goal_write') )
			return TRUE;

		$this->CI->load->model('goal/goal_model');
		if ($this->CI->goal_model->is_goal_admin() )
			return TRUE;
		else {
			if ($this->CI->goal_model->is_goal_creator($goalid) || $this->CI->goal_model->is_goal_member($goalid) ) {
				$this->change_action2read();
				return TRUE;
			}
		}
		return FALSE;
	}
}