<?php
/**
 * configfactory.php
 *
 * Unit config factory. This factory will add the following properties:
 * 	template_identifier - Like unit, goal, survey etc.
 * 	template_file - Like [ORG]_ubd
 * 	template_file_part - like ubd, pyp, myp
 * 	stage_num - The total number of stages. Add if not defined in template.
 * 	extra[] - The extra array. Add empty array if not defined in template.
 *
 * Look at the comments in self::init_template() for non-standard properties.
 *
 * @author $Author: dtong $
 * @version $Id: configfactory.php,v 1.14 2011/05/13 03:39:31 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class configfactory {
	//Some code like outcomes/lt will break if no 'ubd' template
	const DEFAULT_TEMPLATE_FILEPART = CMS_TEMPLATE_DEFAULT;

   public static function factory($template='', $folder_hint='') {
   	//Note, the template folder names have to be the same as these constants
   	global $g_template_id_array;
   	$folders = $g_template_id_array;

   	//Defaults to ubd template for cms_unit_org
   	if ( empty($template) ) {
   		$CI =& get_instance();
   		$template = $CI->config->item('cms_unit_org') . '_' . self::DEFAULT_TEMPLATE_FILEPART;
   	}

   	//Modify the folders array so always check the folder hint first if there is one.
   	//Use hashed index to prevent duplicated folder
   	if ( $folder_hint ) {
   		$tmp = array();
   		$tmp[$folder_hint] = $folder_hint;
   		foreach ($folders as $folder) {
   			$tmp[$folder] = $folder;
   		}
   		$folders = & $tmp;
   	}

		//Can't find the template yet so look thru the possible folders.
		//The templates filenames have to be unique among all the folders here and the default unit template folder
		foreach ($folders as $folder) {
			//if ( @include_once 'config/' . '/' . $folder . '/' . $template . '.php') {
			if ( @include_once CMS_TEMPLATEPATH_BUILDER . $folder . '/' . $template . '.php') {
				$data = unit_config_data::get();
				//PHP source folder names same as identifiers.
				//All template objects will contain this field.
				self::init_template($data, $folder, $template);
				return $data;
			}
		}
		return FALSE;
   }

   /*
    * Init. the template object. Additional non-standard fields ($unit_config->):
    * entry_title - Goal entry title
    * entry_types - Goal entry types array.
    * title - used for syrvey title. This should be a generic field to be supported for all templates.
    * lt_type - Learning target type.
    * os_type - Outcome&skill type.
    *
    */
   private static function init_template(&$template_obj, $folder, $template) {
   	if ( !is_object($template_obj) ) {
   		return;
   	}
		$template_obj->template_identifier = $folder;
		$template_obj->template_file = $template;
		$template_obj->template_file_part = osa_str_extract($template, '_', FALSE);
		if ( !isset($template_obj->extra) ) {
			$template_obj->extra = array();
		}
   	if ( !isset($template_obj->stage_num) && isset($template_obj->stage) && is_array($template_obj->stage) ) {
			$template_obj->stage_num = count($template_obj->stage);
		}
   }
}