<?php
/**
 * Searchutil.php - Utility class for search display list.
 *
 * @author $Author: dtong $
 * @version $Id: Searchutil.php,v 1.3 2011/04/08 06:27:46 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/
require_once(APPPATH . 'libraries/mapping/display_list.php');

class Searchutil {
   const SESSION_PREFIX='searchsort_';

   //Deals with all the search sessions. Use a static var to make sure we always have one copy.
   function get_session($name, $reset=TRUE, $destroy_session=TRUE) {
   	static $pool=array();

   	$sessionname = self::SESSION_PREFIX . $name;
   	if ( array_key_exists($sessionname, $pool) ) {
   		return $pool[$sessionname];
   	}

      osa_php_session_start();
      if ( !array_key_exists($sessionname, $_SESSION) ) {
         echo '<br /><br /><br /><center><h2><font color="red">' . lang('gen_search_session_timedout') . '</font><h2></center>';
         exit;
      }
      $ret = unserialize($_SESSION[$sessionname]);
      if ( $destroy_session ) {
      	//If you don't want to update the session then DON'T use this and also run $display.no_session()
      	//PHP will still update the session file but it will not u the modified $display
      	//This is one of the reasons why we don't assign the object and asign serialized object instead to the session
	      $_SESSION[$sessionname] = FALSE;
	      unset($_SESSION[$sessionname]);
      }
      if ( $reset ) {
      	$ret->reset();
      }
      $pool[$sessionname] = & $ret;
      return $ret;
   }
}