<?php
/**
 * menu_gen_lib.php - HTML menu generation library.
 *
 * @author $Author: dtong $
 * @version $Id: menu_gen_lib.php,v 1.5 2011/02/21 06:04:33 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class menu_gen_lib {

	//Generates menu HTML based on the supplied menu template data array.
   public static function render($data) {
   	if ( isset($data) && $data == FALSE ){
   		osa_errorlog(__METHOD__ . " -  Invalidate data in Function gen_lib ", $data);
			echo osa_ajaxmsg(lang('menu_nodatamsg'));
			exit;
   	}
		$CI = &get_instance();
		$IMAGE_FOLDER = osa_imagepath();
	 	$html = '';
	 	$CI->load->library('menu/event/menu_handle_main');

		foreach ($data as $key_menu => $value) {
			if ( array_key_exists('_hr', $value[0]) && $value[0]['_hr'] === TRUE ) {
				$html .= "<hr width='70%' />";
				continue;
			}
			$menu_flag = '';
			if ( isset($value[0]['_menu_flag']) )
				$menu_flag = $value[0]['_menu_flag'];
			if( $menu_flag == 1 ) {
				$html.= '<center>';
				if ( array_key_exists('_menu_header', $value[0]) && !empty($value[0]['_menu_header']) ) {
		 			$html.= '<div class="menuadmin_title">'. $value[0]['_menu_header'] .'</div>';
				}
				$html.= '<table width="100%" border="0">';
	 			$html.= '<tr>';
	 			$multi_icon = FALSE;
	 			foreach ($value as $key_val => $sub) {
	 				//Event handle '_handle'
	 				if ( $CI->menu_handle_main->run($sub) == FALSE ) {
	 					continue;
	 				}
	 				if ( array_key_exists(2, $value) )
	 					$multi_icon = count($value);
	 				if ( $key_val > 0 ) {
	 					if ( $multi_icon ) {
	 						if ( $multi_icon == 2 )
	 							$html.= '<td align="center" width="45%">';
	 						else
	 							$html.= '<td align="center" width="33%">';
	 					}
	 					else {
	 						$html.= '<td align="center">';
	 					}
	 					$menu_title = $sub['_menu_title'];
		 				$div  = '"'. $sub['_menu_divid'] . '"';
		 				$url  = '';

		 				if (isset($sub['_menu_url']) != FALSE && $sub['_menu_url'] != '')
	 						$url  = $sub['_menu_url'];
	 					$href = '"'.base_url().$url.'"';
				 		$src  = $IMAGE_FOLDER . $sub['_menu_image'];
				 		$img  = "<img src='$src' border=0; ><br />";
			 			$html .= '<div class="menuadmin_item">';

	 					if (isset($sub['_menu_new_win'])) {
			 				//if ($CI->config->item('cms_goal_menu_help')){
		 					$div  = $sub['_menu_divid'];
			 				$width = $sub['_width'];
							$height = $sub['_height'];
							$title = $sub['_win_title'] ;
							$html .= "<a onclick='newDhtmlWindow($href, \"$title\", $width, $height, \"$div\"); ";
							$html .=  "return false;' href=$url > $img <span class='menuadmin_item'>$menu_title</span></a>";
			 				//}
			 			}
			 			else{
			 				$html .= "<a href='$url' onclick='ajaxGetpage($div,$href,false);return false;'>" . $img .
			 							'<span class="menuadmin_item">' . $menu_title . "</span></a>";
			 			}

				  		$html .= "</div>";
				  		if ( array_key_exists('_menu_hr', $sub) && $sub['_menu_hr'] != FALSE )
				  			$html .= "<hr width='70%' />";

				  		$html.= '</td>';
	 				}
	 			} //foreach
	 			$html.= '</tr>';
	 			$html.= '</table>';
	 			$html .= "</center>";
			} // if( $menu_flag == 1 )
	 	} //1st foreach
	   return  $html;
	}
}