<?php
/**
 * menu_gen_data.php - This class prvodes an interface that dynamically generates a menu template.
 *
 * @author $Author: samarth
 * @version $Id: menu_gen_data.php
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class menu_gen_data {

	private $data = array();
	private $index1 = 0; //First array index

	function __construct() {
	}

	function reset() {
		$this->data = array();
		$this->index1 = 0;
	}

	//Move to the next column
	function next() {
		$this->index1++;
	}

	//Always the first element in index1 and no subsequent element
	function add_hr() {
		$this->data[$this->index1][] = array('_hr' => TRUE);
		$this->next();
	}

	//Adds the first element
	//This is always required for every new index1 value
	function add_header($text, $use_header=TRUE) {
		$this->data[$this->index1][] = array('_menu_header' => $text, '_menu_flag'  => $use_header);
	}

	//Adds the link
	function add_link($title, $image, $url, $divid, $hr=FALSE, $extra_params=FALSE,
							$new_win=FALSE, $win_title='', $width=600, $height=450) {
		//Always need header element in index1=0
		//Do this so the code outside of this calss doesn't have to worry about this requirement
		if ( !array_key_exists($this->index1, $this->data) )
			$this->add_header('');
		$data = array('_menu_title' => $title, '_menu_image' => $image, '_menu_divid' => $divid,
							'_menu_url' => $url);
		if ( $hr != FALSE )
			$data['_menu_hr'] = TRUE;
		if ( $new_win == TRUE ) {
			$data['_menu_new_win'] = TRUE;
			$data['_win_title'] = $win_title;
			$data['_width'] = $width;
			$data['_height'] = $height;
		}
		if ( $extra_params !== FALSE && is_array($extra_params) ) {
			$data = array_merge($data, $extra_params);
		}
		$this->data[$this->index1][] = $data;
	}

	function get_data() {
		return $this->data;
	}
}