<?php
/**
 * Menu_handle_main.php - The main class for menu event handles.
 *
 * @author $Author: dtong $
 * @version $Id: Menu_handle_main.php,v 1.5 2011/03/24 09:37:16 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class Menu_handle_main {
	private $CI = NULL;

	function __construct() {
		$this->CI = & get_instance();
	}

	function run($data) {
		if ( is_array($data) && array_key_exists('_handle', $data) ) {
			$handle = $data['_handle'];
			$handle_name = 'mhandle_' . $handle;
			if (!@include_once("{$handle_name}.php")) {
				osa_errorlog(__METHOD__ . " - Event handle class file {$handle_name} does not exist", $handle);
				return FALSE;
			}
			$handleobj = $this->CI->cms_cache->object_get($handle_name);
			if ( empty($handleobj) ) {
				osa_errorlog(__METHOD__ . " - Event handle class {$handle_name} does not exist", $handle);
				return FALSE;
			}
			$handleobj->reset($data);
			return $handleobj->invoke();
		}
		return TRUE;
	}
}