<?php
/**
 * menu_base.php - This is the main menu class that handles all left-panel menus besides the mapping and department menus.
 *
 * @author $Author: dtong $
 * @version $Id: Menu_main.php,v 1.3 2011/02/11 12:51:20 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

Class Menu_main {
	//The data class for dynamic menu generation
	private $gen_data_obj = NULL;

	function __construct() {
	}

	//Gets the menu template array. $file defaults to $folder if not supplied
	function get_template($folder,$file=FALSE) {
		require_once('menu_factory.php');
		return menu_factory::factory($folder,$file);
	}

	//Generates the HTML from the supplied menu template data array
	//function menu_gen_lib($data) {
	function generate_html($data) {
		require_once('menu_gen_lib.php');
		return menu_gen_lib::render($data);
	}

	//Gets the data generation object
	function get_gen_data() {
		if ( $this->gen_data_obj != NULL ) {
			$this->gen_data_obj->reset();
			return $this->gen_data_obj;
		}
		require_once('menu_gen_data.php');
		$this->gen_data_obj = new menu_gen_data;
		return $this->gen_data_obj;
	}
}
?>