<?php
/**
 * inputobj_select_db.php - The  select database table selection_category search input
 *
 * @author $Author: dtong $
 * @version $Id: inputobj_select_db.php,v 1.3 2011/02/11 12:51:20 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('inputobj_base.php');

class inputobj_select_db extends inputobj_base {

	function __construct($data) {
		parent::__construct($data);
		$this->CI->load->model('menu/menu_model');
	}

	function render($params=false) {
		$rows = $this->CI->menu_model->get_sel_cat($this->get_templatevalue('_select_type'), $params);
		$this->data['_data'] = $rows;
		$html = $this->html_select($this->data);
		return $html;
	}

	private function html_select($data) {
		if ( ($name = osa_value($data, '_name', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _name is missing", $data);
			return '';
		}
		if ( ($dataarray = osa_value($data, '_data', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _data is missing", $data);
			return '';
		}
		//A hack to make the data obtained from PYP,UBD to work with selects
		if (array_key_exists(1,$dataarray)) {
			$tmp_item = $dataarray[1];
			if (is_array($tmp_item))
				$dataarray = $tmp_item;
		}
		$default = osa_value($data, '_default', FALSE);
		$options = osa_value($data, '_options', FALSE);
		if ( $options !== FALSE )
			return form_dropdown($name, $dataarray, $default, $options);
		return form_dropdown($name, $dataarray, $default);
	}
}
?>