<?php
/**
 * inputobj_general.php - The general search input which contains selections for myclasses,
 * 							  all classes, grade and department/subject-area
 *
 * @author $Author: dtong $
 * @version $Id: inputobj_general.php,v 1.18 2011/03/24 08:22:36 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('inputobj_base.php');

class inputobj_general extends inputobj_base {
//const SELECT_ALL = 'all';
//const SELECT_IGNORE = 'ignore';
//const SELECT_SIZE = 17;
const SELECT_SEPARATOR = '----------';
private $select_size = 17;

	function __construct($data) {
		parent::__construct($data);
		$this->CI->load->model('menu/menu_model');
		$this->CI->load->model('unit/unit_model');
		$this->CI->load->helper('form');
		osa_load_lang('mapping');
		if ( ($size = $this->get_templatevalue('_select_size')) !== FALSE )
			$this->select_size = $size;
	}

	function render() {
		$html = '<nobr>';
		$html .= $this->get_mycourses() . ' &nbsp; ';
		$html .= $this->get_allcourses() . ' &nbsp; ';
		$html .= $this->get_allgrades()  . ' &nbsp; ';
		$html .= $this->get_alldepartments();
		return $html . "</nobr><div style='font-size:9px;margin-top:5px'>" . lang('map_multiselect_instruction') . "</div>";
	}

	function render_courses() {
		$html  = $this->get_mycourses() . ' &nbsp; ';
		$html .= $this->get_allcourses() . ' &nbsp; ';
		return $html ;
	}

	public function get_alldepartments($fieldname='_departments') {
		$fieldname = $fieldname . '[]';
		$gradeid = $this->get_gradebytemplate();
		if ( $gradeid !== FALSE ){
			$depts = $this->CI->menu_model->get_departmentbygrade($gradeid);
		}
		else{
			$depts = $this->CI->menu_model->getalldepartment();
		}

		$selections = array('null' => lang('map_nonedept'), '' => self::SELECT_SEPARATOR);

		$default = array();
		foreach ($depts as $dept) {
			$selections[$dept['id']] = $dept['name'];
			$default[] = $dept['id'];
		}

		//$default = array(1,9);//osa_value($selections, '_default', FALSE);
		if(osa_value($this->data, '_deptsel_default_all', FALSE) === TRUE) {
			return form_dropdown($fieldname, $selections, $default, 'size="' . $this->select_size . '" multiple="multiple"');
		}
		else {
			return form_dropdown($fieldname, $selections, 'xxxZZZ', 'size="' . $this->select_size . '" multiple="multiple"');
		}

	}

	public function get_allgrades($fieldname='_grades') {
		$fieldname = $fieldname . '[]';
		$gradeid = $this->get_gradebytemplate();
		if ( $gradeid !== FALSE ){
			$grades = $this->CI->menu_model->getgrade($gradeid);
		}
		else{
			$grades = $this->CI->menu_model->getgrade();
		}

		$selections = array('null' => lang('map_nonegrade'), '' => self::SELECT_SEPARATOR);
		foreach ($grades as $grade) {
			$selections[$grade['id']] = $grade['name'];
		}
		return form_dropdown($fieldname, $selections, 'xxxZZZ', 'size="' . $this->select_size . '" multiple="multiple"');
	}

	private function get_mycourses($defaultall=FALSE, $fieldname='_mycourses') {
		$fieldname = $fieldname . '[]';
		/*if ( $this->has_mycourses() ) {
			return "<input type=\"checkbox\" name=\"{$fieldname}\" value=\"1\" /> " . lang('map_mycourses');
		}*/
		$user = $this->CI->login_model->getLogin();
		$courses = $this->CI->menu_model->mycourses($user->id);
		if ( count($courses) > 0 ) {
			/*$selections = array(CMS_SELECT_ALL => lang('map_nonemycourses'),
				self::SELECT_IGNORE => lang('map_selectignore'), '' => self::SELECT_SEPARATOR);*/

			if ( count($courses) > 1) {
				$ids = '';
				$comma = '';
				foreach ($courses as $course) {
					$ids .= $comma . $course['id'];
					$comma = ',';
				}
				$selections = array('null' => lang('map_nonemycourses'),'' => self::SELECT_SEPARATOR,
										  "$ids"=>lang('map_allmycourses'));
			}
			else {
				$selections = array('null' => lang('map_nonemycourses'),'' => self::SELECT_SEPARATOR);
			}
			//Use natural sort
			osa_array_natsort($courses, 'name');
			foreach ($courses as $course) {
				$selections[$course['id']] = $course['name'];
			}
			if ( $defaultall )
				$selected = CMS_SELECT_ALL;
			else
				$selected = 'xxxZZZ';
			return form_dropdown($fieldname, $selections, $selected, 'size="' . $this->select_size . '" multiple="multiple"');
		}
		return FALSE;
	}

	private function get_allcourses($defaultall=FALSE, $fieldname='_courses') {
		$fieldname = $fieldname . '[]';
		$gradeid = $this->get_gradebytemplate();
		if ( $gradeid !== FALSE ){
			$courses = $this->CI->menu_model->get_courses($gradeid);
		}
		else{
			$courses = $this->CI->unit_model->get_enable_courses();
		}
		$selections = array();
		//Use our own natural sort to sort the course names
		osa_array_natsort($courses, 'course');
		if (isset($courses) && $courses != FALSE){
			foreach ($courses as $course) {
				$selections[$course->courseid] = $course->course;
			}
		}
		//Sort based on course name and retain array index which is the course number
		//asort($selections, SORT_LOCALE_STRING);
		/*$tmparray = array(CMS_SELECT_ALL => lang('map_nonecourse'),
			self::SELECT_IGNORE => lang('map_selectignore'), '' => self::SELECT_SEPARATOR);*/
		$tmparray = array('null' => lang('map_nonecourse'),'' => self::SELECT_SEPARATOR);
		//$selections = array_merge($tmparray, $selections);
		//Do copy and retain indexes, array_merge() resets indexes
		foreach ( $selections as $key => $selection) {
			$tmparray[$key] = $selection;
		}
		if ( $defaultall )
			$selected = CMS_SELECT_ALL;
		else
			$selected = 'xxxZZZ';
		return form_dropdown($fieldname, $tmparray, $selected, 'size="' . $this->select_size . '" multiple="multiple"');
	}

	//Gets all the grades according to a template (ubd, pyp, myp etc.)
	private function get_gradebytemplate() {
		if (isset($this->data['_template']) && $this->data['_template'] !=FALSE){
			$template = $this->data['_template'];
			$unit_template =  $this->CI->config->item('cms_unit_templates');
			$gradeid = array();
			if (is_array($unit_template) && is_array($template)){
				foreach ($unit_template as $key=>$value){
					foreach ($template as $index){
						if (in_array($index,$value))
							$gradeid[] = $key;
					}
				}
			}
			//Start of (issue: 133)
			$db_grades = $this->CI->menu_model->getgrade();
			if ( $db_grades ) {
				//Find grades that are not defined in cms_unit_templates and add them
				foreach ($db_grades as $record) {
					if ( !array_key_exists($record['id'], $unit_template) ) {
						$gradeid[] = $record['id'];
					}
				}
			}
			//End of (issue: 133)
			return $gradeid;
		}
		return FALSE;
	}

/*
	private function has_mycourses() {
		$user = $this->CI->login_model->getLogin();
		$courses = $this->CI->menu_model->mycourses($user->id);
		if ( count($courses) == 0 )
			return FALSE;
		return TRUE;
	}
*/
}
?>