<?php
/**
 * inputobj_allunits.php - The eq search input which contains selections for myclasses,
 * 							  all classes, grade and department/subject-area
 *
 * @author $Author: dtong $
 * @version $Id: inputobj_allunits.php,v 1.5 2011/02/11 14:09:29 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('inputobj_base.php');
require_once ('inputobj_general.php');

class inputobj_allunits extends inputobj_base {
//const SELECT_ALL = 'all';
//const SELECT_IGNORE = 'ignore';
//const SELECT_SIZE = 17;
const SELECT_SEPARATOR = '----------';
private $select_size   = 15;
private $div_department= 'map_eq_department';
private $div_essential = 'map_eq_essential';
private $formname 	   = 'eq_form';
private $url	       = 'map/select/get/essential/';
private $span_id	   = '';
private $span_text	   = '';
private $span_default  = '';

	function __construct($data) {
		parent::__construct($data);

		$this->CI->load->model('mapping/eq_model');
		$this->CI->load->helper('form');
		osa_load_lang('mapping');
		if ( ($size = $this->get_templatevalue('_select_size')) !== FALSE )
			$this->select_size = $size;

		if ( ($form = $this->get_templatevalue('_form')) !== FALSE )
			  $this->formname = $form;
		if ( ($div_department = $this->get_templatevalue('_div_department')) !== FALSE )
			  $this->div_department = $div_department;
		if ( ($div_essential = $this->get_templatevalue('_div_essential')) !== FALSE )
			  $this->div_essential = $div_essential;
		if ( ($url = $this->get_templatevalue('_url')) !== FALSE )
			  $this->url = $url;

		if ( ($span_id         = $this->get_templatevalue('_span_id')) !== FALSE )
			  $this->span_id   = $span_id;
		if ( ($span_text       = $this->get_templatevalue('_span_text')) !== FALSE )
			  $this->span_text = $span_text;
		if ( ($span_default    = $this->get_templatevalue('_span_default')) !== FALSE )
			  $this->span_default = $span_default;
	}

	function render() {
		$general = new inputobj_general($this->data);
		$html = '<nobr>';
		$html .= $general->render_courses();
		$html .= $general->get_alldepartments()  . ' &nbsp; ' ;
		$html .= $general->get_allgrades()  . ' &nbsp; '.'<br />';

		$html .= "</nobr>";
		$html .= "<div style='font-size:9px;margin-top:5px'>" . lang('map_multiselect_instruction')."</div>";
		$html .= "<div id='$this->div_essential' style='margin-top:10px'></div>";
		return $html;
	}

	private function get_alldepartments($fieldname='_departments') {
		$fieldname = $fieldname . '[]';
		$depts = $this->CI->menu_model->getalldepartment();

		$selections = array('null' => lang('map_nonedept'), '' => self::SELECT_SEPARATOR);
		foreach ($depts as $dept) {
			$selections[$dept['id']] = $dept['name'];
		}

		$data = array('_clear'=>0, '_url'=>$this->url, '_formname'=>$this->formname,'_div'=>$this->div_essential,
			          '_span_id'=>$this->span_id, '_span_text'=>$this->span_text, '_span_default'=>$this->span_default);


		$onClick = $this->CI->eq_model->onClick($data);
		return form_dropdown($fieldname, $selections, 'xxxZZZ', 'size="' . $this->select_size .'" '. $onClick  ) ;
	}
}
?>