<?php
/**
 * input_page - Library for handling a search page template
 *
 * @author $Author: dtong $
 * @version $Id: input_page.php,v 1.6 2011/05/13 12:47:49 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('input_search.php');

class input_page {
	private $data=NULL;
	private $html='';
	private $searchobj=NULL;

	function __construct($data) {
		$this->data = $data; //This is data for one search type like stage 1 or calendar
		$this->searchobj = new input_search();
	}

	/*
	 * This renders one search page from the template like Calendar, stage 1 etc.
	 */
	function render() {
		if ($this->data == NULL) {
			osa_errorlog(__METHOD__ . " - class data variable is null.");
			return FALSE;
		}
		$data = $this->data[1]; //This is the actual page excluding the [0] for the menu button
		//Loop thru all the items in a search page
		foreach ($data as $key=>$item) {
			$type = osa_value($item, '_type', FALSE);
			if ( $type === FALSE ) {
				osa_errorlog(__METHOD__ . " - _type missing.", $item);
				continue;
			}
			switch ($type) {
				case 'page_title':
					$this->html .= $this->page_title($item);
					break;
				case 'sub_title':
					$this->html .= $this->sub_title($item);
					break;
				case 'line':
					$this->html .= '<div class="map_line"></div>';
					break;
				case 'search':
					//This will use the input_search class generate one single search
					$searchdata = osa_value($item, '_data', FALSE);
					$searchid = osa_value($item, '_uniqueid', FALSE);
					if ( $searchdata !== FALSE && $searchid !==FALSE ) {
						$this->searchobj->reset($searchid, $searchdata);
						$this->html .= '<div class="map_section">' . $this->searchobj->render() . '</div>';
					}
					else {
						osa_errorlog(__METHOD__ . " - _data or _uniqueid missing for search type.", $item);
					}
					break;
				default:
					osa_errorlog(__METHOD__ . " - unknown _type {$type}.", $item);
			}
		}
		//The is the actual input page HTML. Add empty space at the end of the page.
		return $this->html . '<br /><br />';
	}

	private function page_title($data) {
		$text = osa_value($data, '_text', FALSE);
		if ( $text === FALSE ) {
			osa_errorlog(__METHOD__ . " - _text is not found.", $data);
			return '';
		}
		$html = "<center><div class='map_title'>$text</div>";
		return $html;
	}

	private function sub_title($data) {
		$text = osa_value($data, '_text', FALSE);
		if ( $text === FALSE ) {
			osa_errorlog(__METHOD__ . " - _text is not found.", $data);
			return '';
		}
		$html = "<center><div class='map_subtitle'>$text</div>";
		return $html;
	}

}

?>