<?php
/**
 * Handle_understanding.php - Handle/Search for handling displaying list of units and Central Ideas/Understandings.
 *
 *
 * @author $Author: dtong $
 * @version $Id: Handle_understanding.php,v 1.8 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_understanding extends Handle_base{

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/unit_select_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$res_type = $this->get_templatevalue('_res_type');
		$res = $this->CI->unit_select_model->get_understandings($course_query,$res_type);

		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$display->divid = $this->get_inputvalue('_divid');

		$_columns = $this->get_templatevalue('_columns');
		$display->titles = FALSE;
		$display->widths = FALSE;
		if ($_columns !== FALSE ){
			$display->titles = $_columns['_col_name'];
			$display->widths = $_columns['_col_width'];
		}
		//This loop will consolidate the different selections from the same units into one entry
		if ( $res ) {
			$this->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				$data = array($item->coursename, $item->unit_title, $item->text);
				$this->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
				$display->add($data);
			}
		}
		$this->load_view($display);
	}
}
?>