<?php
/**
 * Handle_seltds.php - Handle/Search for handling displaying list of units and selections Trans-disciplinary Skills
 *
 * @author $Author: dtong $
 * @version $Id: Handle_seltds.php,v 1.9 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');
require_once ('Handle_graph.php');
class Handle_seltds extends Handle_base{

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/unit_select_model');
	}

	function process() {
		$showgraph = $this->get_requestvalue('_showgraph');
		if ( isset($showgraph) && $showgraph != FALSE  ) {
			//Show graph option is checked so call the graphical version handle
			$this->obj = new Handle_graph($this->params);
			return $this->obj->process();
		}
		//Continue with the text version
		$course_query = $this->get_calendar_query();
		//This is the array containing values of select1, select2
		//$unitsel = $_POST['_unit_select'];
		$unitsel = $this->get_requestvalue('_unit_select');
		if ( !isset($unitsel) && !is_array($unitsel)  ) {
			echo osa_ajaxmsg(lang('map_no_unitselect'));
			exit;
		}
		$query = $this->CI->unit_select_model->get_tds_query($course_query,$unitsel);
		$res = $this->CI->unit_select_model->run_query($query);
		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title').' ('.$unitsel.')';
		$display->divid = $this->get_inputvalue('_divid');
		$_columns = $this->get_templatevalue('_columns');
		$display->titles = FALSE;
		$display->widths = FALSE;
		if ($_columns !== FALSE ){
			$display->titles = explode(',',sprintf( implode(',',$_columns['_col_name']), $unitsel) );
			$display->widths = $_columns['_col_width'];
		}

		//This loop will consolidate the different selections from the same units into one entry
		$lastunitid = '';
		$text = '';
		$comma='&#8226; ';
		if ( $res ) {
			$this->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				if ( $lastunitid == '' ) {
					$lastunitid = $item->unitid;
				}
				if ( $lastunitid != $item->unitid) {
					$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
					$display->add($data);
					$lastunitid = $item->unitid;
					$text='';
					$comma='&#8226; ';
				}
				$_text = explode('-',$item->text);
				if (array_key_exists(1,$_text)) {
					$text .= $comma . $_text[1].'<br />';
				}
				$data = array($item->coursename, $item->unit_title, $item->description, $text);
			}
			$this->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
			$display->add($data);
		}
		$this->load_view($display);
	}
}
?>