<?php
/**
 * Handle_selcat.php - Handle/Search for handling displaying list of units and selections
 * 						  This is very similiar to the grapics version Handle_unitsel in terms of the data being searched but
 * 						  the code is somewhat different and may be simplier than the graphics version
 *
 * @author $Author: dtong $
 * @version $Id: Handle_selcat.php,v 1.21 2011/05/31 10:47:55 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');
class Handle_selcat extends Handle_base{

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/unit_select_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		//This is the array containing values of select1, select2
		$unitsel = $this->get_requestvalue('_unit_select');
		if ( $unitsel === FALSE ) {
			echo osa_ajaxmsg(lang('map_no_unitselect'));
			exit;
		}
		$_template = $this->get_requestvalue('_template');
		$_select_index = $this->get_templatevalue('_select_index');
		$_select_template_msg = $this->get_templatevalue('_select_template_msg');

		$_params =  array('template'=>$_template, 'select_index'=>$_select_index,'select_template_msg'=>$_select_template_msg);


		//This is the unit config type
		$type = $this->get_templatevalue('_type');
		$query = $this->CI->unit_select_model->get_list_query($course_query,$unitsel,$type,$_params);
		$res = $this->CI->unit_select_model->run_query($query);
		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$select_description = osa_value($this->get_templatevalue('_data_category'), $unitsel, FALSE);
		$select_options = $this->get_templatevalue('_data');
		$select_options = osa_value($select_options, $unitsel, FALSE);
		if ( $select_options === FALSE )
			$select_options = array(); //This is a problem should never happen unless soomeone wants to hack the site
		$display->titles = array(lang('map_course'),lang('map_unit'),$this->get_templatevalue('_description_name'),$select_description);
		//Set the size for each TD
		$display->widths = array('16%','16%','45%','33%');
		$display->divid = $this->get_inputvalue('_divid');
		//$display->column_use_striptag[2] = TRUE;
		/*
		$_columns = $this->get_templatevalue('_columns');
		if ($_columns !== FALSE ){
			$display->titles = explode(',',sprintf( implode(',',$_columns['_col_name']), $select_description) );
			$display->widths = $_columns['_col_width'];
		}
		*/
		$show_unit_template = osa_unit_template();
		if ( $show_unit_template != FALSE) {
			$display->titles[] = lang('map_selcat_unittype');
			$display->widths[] = '5%';
		}
		//$display->closebutton = TRUE; //divid has to be defined for this to work
		if ( $res ) {
			if ( ($is_checkbox = $this->is_checkbox($res, $select_options)) == TRUE ) {
				//It is checkbox data so let's skip the last column
				$display->widths = array('27%','27%','56%');
				$display->titles = array(lang('map_course'),lang('map_unit'),$this->get_templatevalue('_description_name'));
				//Add the checkbox title to the page title
				$display->pagetitle .= " ($select_description)";
			}
			$lastunitid = '';
			$desc = ''; $comma='&#8226; ';
			$act_desc = '';
			$lastresourceid = '';
			$check_resourceid = TRUE;
			if ( $is_checkbox ) {
				//Check box is always a single entry so we want to group them based on a unit and not a resource
				$check_resourceid = FALSE;
			}
			$this->add_urllink_template_str(1, $display);
			//This loop will consolidate the different selections from the same units into one entry
			foreach ( $res as $item ) {
				if ( $lastunitid == '' ) {
					$lastunitid = $item->unitid;
					$lastresourceid = $item->resourceid;
				}
				if ( $lastunitid != $item->unitid || ($check_resourceid && $lastresourceid != $item->resourceid) ) {
					//$data[3] = $desc;
					$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
					$display->add($data);
					$lastunitid = $item->unitid;
					$lastresourceid = $item->resourceid;
					$desc='';$comma='&#8226; ';
					$act_desc = '';
				}
				$url = base_url() . "unit/unit/read/{$item->unitid}";
				$unithtml = "<a class=\"cmslink\" href=\"$url\" onclick=\"newDhtmlWindow('$url','" . lang('map_unit') .
									"',900,800,'unitread');return false;\">{$item->unit_title}</a>";
				if ( array_key_exists($item->selectvalue, $select_options) )
					$desc .= $comma . $select_options[$item->selectvalue];
				else
					osa_errorlog(__METHOD__ . " - select index value missing: {$item->selectvalue}", $select_options);

				if ( $is_checkbox ) {
					//Group the activities together
					$act_desc .= $comma . strip_tags(html_entity_decode($item->res_description));
					$data = array($item->coursename, $item->unit_title, $act_desc);
				}
				else {
					//A actitvity can have multiple slections so all actitvity are separated.
					$act_desc = strip_tags(html_entity_decode($item->res_description));
					$data = array($item->coursename, $item->unit_title, $act_desc, $desc);
				}
				if ( $show_unit_template && isset($item->template)){
					$unit_typ =lang('unit_typename_'.$item->template);
					$data[] = $unit_typ;
				}

				$comma='<br />&#8226; ';
			}
			$this->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
			$display->add($data);
		}
		$this->load_view($display);
	}

	//Loops thru the whole query result to see do we have text in the selected field from the template
	function is_checkbox($res, $select_options) {
		foreach ($res as $item) {
			if ( array_key_exists($item->selectvalue, $select_options) ) {
				$select_text = $select_options[$item->selectvalue];
				if ( $select_text != '' )
					return FALSE;
			}
		}
		return TRUE;
	}

}
?>