<?php
/**
 * Handle_lt.php - List Learning Targets based on user search input
 *
 * @author $Author: dtong $
 * @version $Id: Handle_lt.php,v 1.19 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_lt extends Handle_base{
	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/maplt_model');
		osa_load_lang('unit');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$_template = $this->get_requestvalue('_template');
		if (is_array($_template)) {
			$temp = implode('',$_template);
			if ($temp == '') {
				echo osa_ajaxmsg($this->get_templatevalue('_select_template'));
				exit;
			}
		}

		$res = $this->CI->maplt_model->get($course_query, $_template);
		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');

		if ( ($strand_title = $this->get_templatevalue('strand_title')) == FALSE )
			$strand_title = lang('map_strand');
		if ( ($benchmark_title = $this->get_templatevalue('_benchmark_title')) == FALSE )
			$benchmark_title = lang('map_benchmark');
		if ( ($target_title = $this->get_templatevalue('_target_title')) == FALSE )
			$target_title = lang('map_target');

		$skip_benchmark = $this->CI->config->item('cms_hide_benchmarks');

		$show_unit_template = osa_unit_template();

		$display->titles = array(lang('map_course'),lang('map_unit'));

		$skip_strand = !$skip_benchmark;

		//$skip_strand = $this->get_templatevalue('_skip_strand');
		$skip_standard = $this->get_templatevalue('_skip_standard');

		if ( $skip_standard ) {
			$display->widths = array('15%','15%');

			if ( !$skip_benchmark ) {
				$display->titles[] = $benchmark_title;
				$display->widths[] = '30%';
			}

			$display->titles[] = $target_title;
			$display->widths[] = '30%';
		}
		else {
			$display->widths = array('13%','13%');
			/*
			if ( !$skip_strand ) {
				$display->titles[] = $strand_title;
				$display->widths[] = '20%';
			}
			*/
			$display->titles[] = lang('map_standard');
			$display->widths[] = '21%';

			if ( !$skip_benchmark ) {
				$display->titles[] = $benchmark_title;
				$display->widths[] = '27%';
			}

			$display->titles[] = $target_title;
			$display->widths[] = '26%';
		}
		$_use_col_unit_type = $this->get_templatevalue('_use_column_unit_type');
		if ( $show_unit_template != FALSE && $_use_col_unit_type != FALSE) {
			$display->titles[] =	lang('map_unit_type');
			$display->widths[] = '5%';
		}
		/*
		$_columns = $this->get_templatevalue('_columns');
		if ($_columns !== FALSE ){
			$temp = $_columns['_col_name'];
			//$display->titles = $_columns['_col_name'];
			$display->widths = $_columns['_col_width'];

			if ( $show_unit_template == FALSE) {
			 	$del = array('Unit Type');
			 	$temp = array_diff($temp, $del);
			}
			if ($skip_standard) {
				$del = array(lang('map_standard'));
				$temp = array_diff($temp, $del);
			}
			$display->titles = $temp;
		}
			*/
		//Set the size for each TD
		$display->divid = $this->get_inputvalue('_divid');
		//$display->closebutton = TRUE; //divid has to be defined for this to work
		if ( $res ) {
			$this->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				//Display list will automatically put column 1 text $item->unit_title into the template string
				$data = array($item->coursename, $item->unit_title);
				/*
				if ( !$skip_strand )
					$data[] = $item->strand;
				*/
				if ( !$skip_standard )
					$data[] = $item->standard;

				if ( !$skip_benchmark )
					$data[] = $item->benchmark;

				$data[] = $item->target;

				if ( $show_unit_template && isset($item->template) && $_use_col_unit_type) {
					//unit type - ubd, myp or pyp. Always lower case in DB  and use lang to display it properly
					$data[] = lang('unit_typename_' . $item->template);
				}
				$this->add_hidden_data(1, $data, "$item->unitid,$item->unitid");
				$display->add($data);
			}
		}
		$this->load_view($display);
	}
}