<?php
/**
 * Handle_graph.php - Search handle for handling a graph  searches
 * 							A handle can be designed to handle multiple searches like this one
 *
 * @author $Author: dtong $
 * @version $Id: Handle_graph.php,v 1.9 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

require_once('Handle_base.php');
require_once('display_list.php');
class Handle_graph extends Handle_base{

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/map_graph_model');
		$this->CI->load->model('mapping/unit_select_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$params = array();
		$_restype = $this->get_templatevalue('_restype');
		$params['_restype'] = $_restype;
		$_unitsel = $this->get_requestvalue('_unit_select');
		if ( $_unitsel === FALSE ) {
			echo osa_ajaxmsg(lang('map_no_unitselect'));
			exit;
		}
		$params['_select_type'] = $_unitsel;
		$_template = $this->get_templatevalue('_template');
		$params['_template'] = $_template;
		$_req_template = $this->get_requestvalue('_template');
		if (is_array($_req_template)) {
			$temp = implode('',$_req_template);
			if ($temp == '') {
				echo osa_ajaxmsg($this->get_templatevalue('_select_template_msg'));
				exit;
			}
			$params['_template'] = $_req_template;
		}

		$_title = $this->get_templatevalue('_title');
		$_data = $this->get_templatevalue('_data');

		$function_data = FALSE;
		$function_click = FALSE;
		if (isset($_data) && $_data != FALSE){
			$options = $_data[$_unitsel];
			$function_data = 'graphbyresource_select_data';
			$function_click = 'graphbyresource_select_click';
		}
		else{
			$function_data = 'graphbyunit_selection_data';
			$function_click = 'graphbyunit_selection_click';
			$options = $this->CI->map_graph_model->get_category($params);
		}


		if (isset($_unitsel) && !is_numeric($_unitsel)){
			if (isset($options) && $options != FALSE){
				foreach ($options as $key=>$value){
					$data = explode('-', $value);
					if (array_key_exists(1,$data))
						$options[$key] = $data[1];
				}
				$nodata_options = $options;
			}
			$_title = $this->get_templatevalue('_title') . ' - ' . $_unitsel;
		}
		$_select_index = $this->get_templatevalue('_select_index');
		$_select_template_msg = $this->get_templatevalue('_select_template_msg');
		$_params = FALSE;
		if ($_select_index != FALSE ){
			$_params =  array('template'=>$_req_template, 'select_index'=>$_select_index, 'select_template_msg'=>$_select_template_msg);

			$res = $this->CI->unit_select_model->graph_data($course_query, $_unitsel, $_restype, FALSE, FALSE, $_params);
			$click_query = $this->CI->unit_select_model->get_click_query($course_query, $_unitsel, $_restype, $_params);
		}
		else{
			$res = $this->CI->map_graph_model->$function_data($course_query, $params);
			$click_query = $this->CI->map_graph_model->$function_click($course_query,$params);
		}

		$chartdivid = $this->get_inputvalue('_chart_divid');
		//Save the click query so we can do the search when a pie slice is clicked
		$this->CI->session->set_userdata('sql_' . $chartdivid, $click_query);
		$this->CI->load->library('cms/osa_chart');
		$data = $this->CI->osa_chart->dataobj();
		$data->divid = $chartdivid;
		$nodata_options = $options;
		$chart_width = $this->get_templatevalue('_chartwin_width');
		$chart_height = $this->get_templatevalue('_chartwin_height');
		$result_divid = $this->get_templatevalue('_result_divid');
		$dhtml_divid = $this->get_inputvalue('_divid');

		if ( $res === FALSE )
			$res = array();
		//Add the data to pie slices
		foreach ($res as $item) {
			if ( !array_key_exists($item->selectvalue, $options) ) {
				osa_errorlog(__METHOD__ . " - Invalid select value: {$item->selectvalue}", $options);
				continue;
			}
			$choice_name = $options[$item->selectvalue];
			$data->addslice(($item->total*1),$options[$item->selectvalue],
				"showChartUnitlist('" . base_url() . "chart/chartlist/get/$this->searchid/$item->type/$item->selectvalue'," .
					"'$choice_name" .
					"',$chart_width,$chart_height,'$result_divid', '$dhtml_divid')");
			unset($nodata_options[$item->selectvalue]);
		}

		$this->CI->load->library('cms/osa_chart');
		$this->CI->osa_chart->prepare_pie();
		//This contains all the selections that are not used/selected
		$nodata_title = $this->get_templatevalue('_no_select_items');
		$this->CI->load->view('mapping/chart_view.php',
			array('chart'=>$this->CI->osa_chart, 'title'=>$_title, 'nodata_options'=>$nodata_options,
				'count' => count($res), 'nodata_title'=>$nodata_title, 'divid'=>$dhtml_divid));
	}

}
?>