<?php
/**
 * Handle_formative.php - Handle/Search for handling displaying list of units and selections Formative Assessment
 *
 * @author $Author: dtong $
 * @version $Id: Handle_formative.php,v 1.8 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_formative extends Handle_base{

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/unit_select_model');
		$this->CI->load->model('menu/menu_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$params = array();
		$_template = $this->get_requestvalue('_template');
		if (is_array($_template)) {
			$temp = implode('',$_template);
			if ($temp == '') {
				echo osa_ajaxmsg($this->get_templatevalue('_select_template'));
				exit;
			}
			$params['template'] = $_template;
		}

		$params['type'] = $this->get_templatevalue('_res_type');
		$query = $this->CI->unit_select_model->get_formative_assessment_query($course_query,$params);
		$res = $this->CI->unit_select_model->run_query($query);


		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$display->divid = $this->get_inputvalue('_divid');

		$_columns = $this->get_templatevalue('_columns');
		$display->titles = FALSE;
		$display->widths = FALSE;
		if ($_columns !== FALSE ){
			$display->titles = $_columns['_col_name'];
			$display->widths = $_columns['_col_width'];
		}
		if ( $res ) {
			$this->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				$unit_typ =lang('unit_typename_'.$item->template);
				$data = array($item->coursename, $item->unit_title, $item->description, $item->text,$unit_typ);
				$this->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
				$display->add($data);
			}
		}
		$this->load_view($display);
	}

}
?>