<?php
/**
 * menutree html element - create html element
 *
 * @author $Author: dtong $
 * @version $Id: jstree_html_element.php,v 1.6 2011/02/03 13:29:28 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/


class jstree_html_element {
	public $type;
	public $attributes;
	// some element has self closer by itself such as <img /> <input />
	public $self_closers;

	// constructor
	function __construct($type, $self_closers = array('input', 'img', 'hr', 'br', 'meta', 'link') ) {
		$this->type = strtolower($type);
		$this->self_closers = $self_closers;
		$this->attributes = array();
	}
	// set id tag to html object
	function set_id($value){
		$this->set('id', $value);
		return TRUE;
	}

	// set class tag to html object
	function set_class($value){
		$this->set('class', $value);
		return TRUE;
	}

	// set jstree closed class tag to html object
	function set_class_jstreeclosed(){
		$this->set('class', 'jstree-closed');
		$this->set('rel', 'folder');
		return TRUE;
	}

	// set jstree leaf class tag to html object
	function set_class_jstreeleaf(){
		$this->set('class', 'jstree-leaf');
		//This is a new type added to jscript in menutree_view.php
		//You can create a new set_class_xxx function with a new type too.
		$this->set('rel', 'file');
		return TRUE;
	}

	// set title tag to html object
	function set_title($value){
		$this->set('name', $value);
		return TRUE;
	}

	function set_href_novalue(){
		$this->set('href', '');
		return TRUE;
	}

	// set inner text to html object
	function set_innertext($value){
		$this->set('text', $value);
		return TRUE;
	}

	//set the element such as id, class or text
	function set($attribute, $value = NULL) {
		if( is_array($attribute) ) {
			$this->attributes = array_merge($this->attributes, $attribute);
		}
		else {
			$this->attributes[$attribute] = $value;
		}
		return TRUE;
	}

	function override_type($value) {
		$this->attributes['rel'] = $value;
	}

	// append into html object
	function append_html($html_object) {
		if( @get_class($html_object) == __class__ ){
			if( !isset($this->attributes['text']) ){
				$this->attributes['text'] = $html_object->render();
			}
			else{
				$this->attributes['text'].= $html_object->render();
			}
		}
	}

	// build the elemnet
	function render() {
		$build = '<'.$this->type;
		//add attributes
		if( count($this->attributes) && !is_null($this->attributes) ) {
			foreach( $this->attributes as $key=>$value ) {
				if($key != 'text') {
					$build .= ' '.$key.'="'.$value.'"';
				}
			}
		}
		//closing the element: check if type has self closer or not
		if( !in_array($this->type,$this->self_closers) ) {
			$build .= '>'.$this->attributes['text'].'</'.$this->type.'>';
		}
		else {
			$build .= ' />';
		}
		return $build;
	}
}

class jstree_generate{

	/* generate jstree node by using html list
	 * @param string $id_name Name of id in html tag
	 * @param string $innertext Text between strat and end html tag
	 * @param string $url Url included base_url()
	 * @param array $data_array Query result as a pure array
	 * @param boolean $no_result check node has result or not
	 * @param boolean $expand check node can expand or not
	 * @return string $html Concatenation of html string
	 */
	function render($id_name, $innertext, $url, $data_array, $no_result, $expand, $override_type=FALSE){
		//$this->nocache();
		$html = '';
		$obj_container = array();
		// Data has query result as an array
		if( is_array( $data_array ) ) {
			foreach ( $data_array as $result ){
				$get_id = $id_name.$result['id'];
				$list_obj = new jstree_html_element('li');
				$list_obj->set_id($get_id);
				$list_obj->set_class_jstreeclosed();
				//$get_link = $url.$result['id']."/";
				$get_link = sprintf($url, $result['id']);
				$url_obj = new jstree_html_element('a');
				$url_obj->set_title($get_link);
				$url_obj->set_href_novalue();
				$url_obj->set_innertext($result['name']);
				$list_obj->append_html($url_obj);
				//$html .= $list_obj->render();
				$obj_container[] = $list_obj;
				// reset id
				$get_id = '';
			}
		}
		// Node has no result
		else if ( $no_result ){
			$list_obj = new jstree_html_element('li');
			$list_obj->set_id($id_name);
			$list_obj->set_class_jstreeleaf();
			$span_obj = new jstree_html_element('span');
			$span_obj->set_innertext($innertext);
			$list_obj->append_html($span_obj);
			//$html .= $list_obj->render();
			$obj_container[] = $list_obj;
		}
		// Data doesn't has a link and is leaf node (no expand)
		// Leaf node is mean the open icon will no longer be displayed
		else if ( is_null( $url ) && $expand == FALSE ){
			$list_obj = new jstree_html_element('li');
			$list_obj->set_id($id_name);
			$list_obj->set_class_jstreeleaf();
			$list_obj->set_innertext($innertext);
			//$html .= $list_obj->render();
			$obj_container[] = $list_obj;
		}
		// Data doesn't has a link
		else if ( is_null( $url ) ){
			$list_obj = new jstree_html_element('li');
			$list_obj->set_id($id_name);
			$list_obj->set_class_jstreeclosed();
			$list_obj->set_innertext($innertext);
			//$html .= $list_obj->render();
			$obj_container[] = $list_obj;
		}
		else{
			$list_obj = new jstree_html_element('li');
			$list_obj->set_id($id_name);
			$list_obj->set_class_jstreeclosed();
			$url_obj = new jstree_html_element('a');
			$url_obj->set_title($url);
			$url_obj->set_href_novalue();
			$url_obj->set_innertext($innertext);
			$list_obj->append_html($url_obj);
			//$html .= $list_obj->render();
			$obj_container[] = $list_obj;
		}
		//Don't render the HTML above so we can override the icon type here before rendering
		foreach ($obj_container as $obj) {
			if ( $override_type ) {
				$obj->override_type($override_type);
			}
			$html .= $obj->render();
		}
		return $html;
	 }
}